/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.org.apache.http.protocol;

import codegurushadow.org.apache.http.HttpException;
import codegurushadow.org.apache.http.HttpRequest;
import codegurushadow.org.apache.http.HttpRequestInterceptor;
import codegurushadow.org.apache.http.annotation.Contract;
import codegurushadow.org.apache.http.annotation.ThreadingBehavior;
import codegurushadow.org.apache.http.params.HttpParams;
import codegurushadow.org.apache.http.protocol.HttpContext;
import codegurushadow.org.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestUserAgent
implements HttpRequestInterceptor {
    private final String userAgent;

    public RequestUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public RequestUserAgent() {
        this(null);
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("User-Agent")) {
            String s = null;
            HttpParams params = request.getParams();
            if (params != null) {
                s = (String)params.getParameter("http.useragent");
            }
            if (s == null) {
                s = this.userAgent;
            }
            if (s != null) {
                request.addHeader("User-Agent", s);
            }
        }
    }
}

