/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.org.apache.http.protocol;

import codegurushadow.org.apache.http.HttpException;
import codegurushadow.org.apache.http.HttpResponse;
import codegurushadow.org.apache.http.HttpResponseInterceptor;
import codegurushadow.org.apache.http.annotation.Contract;
import codegurushadow.org.apache.http.annotation.ThreadingBehavior;
import codegurushadow.org.apache.http.protocol.HttpContext;
import codegurushadow.org.apache.http.protocol.HttpDateGenerator;
import codegurushadow.org.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.SAFE)
public class ResponseDate
implements HttpResponseInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        int status = response.getStatusLine().getStatusCode();
        if (status >= 200 && !response.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            response.setHeader("Date", httpdate);
        }
    }
}

