/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.org.joda.time.base;

import codegurushadow.org.joda.time.DurationFieldType;
import codegurushadow.org.joda.time.MutablePeriod;
import codegurushadow.org.joda.time.Period;
import codegurushadow.org.joda.time.ReadablePeriod;
import codegurushadow.org.joda.time.format.ISOPeriodFormat;
import codegurushadow.org.joda.time.format.PeriodFormatter;
import org.joda.convert.ToString;

public abstract class AbstractPeriod
implements ReadablePeriod {
    protected AbstractPeriod() {
    }

    @Override
    public int size() {
        return this.getPeriodType().size();
    }

    @Override
    public DurationFieldType getFieldType(int n) {
        return this.getPeriodType().getFieldType(n);
    }

    public DurationFieldType[] getFieldTypes() {
        DurationFieldType[] durationFieldTypeArray = new DurationFieldType[this.size()];
        for (int i = 0; i < durationFieldTypeArray.length; ++i) {
            durationFieldTypeArray[i] = this.getFieldType(i);
        }
        return durationFieldTypeArray;
    }

    public int[] getValues() {
        int[] nArray = new int[this.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.getValue(i);
        }
        return nArray;
    }

    @Override
    public int get(DurationFieldType durationFieldType) {
        int n = this.indexOf(durationFieldType);
        if (n == -1) {
            return 0;
        }
        return this.getValue(n);
    }

    @Override
    public boolean isSupported(DurationFieldType durationFieldType) {
        return this.getPeriodType().isSupported(durationFieldType);
    }

    public int indexOf(DurationFieldType durationFieldType) {
        return this.getPeriodType().indexOf(durationFieldType);
    }

    @Override
    public Period toPeriod() {
        return new Period(this);
    }

    @Override
    public MutablePeriod toMutablePeriod() {
        return new MutablePeriod(this);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ReadablePeriod)) {
            return false;
        }
        ReadablePeriod readablePeriod = (ReadablePeriod)object;
        if (this.size() != readablePeriod.size()) {
            return false;
        }
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (this.getValue(i) == readablePeriod.getValue(i) && this.getFieldType(i) == readablePeriod.getFieldType(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n = 17;
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            n = 27 * n + this.getValue(i);
            n = 27 * n + this.getFieldType(i).hashCode();
        }
        return n;
    }

    @Override
    @ToString
    public String toString() {
        return ISOPeriodFormat.standard().print(this);
    }

    public String toString(PeriodFormatter periodFormatter) {
        if (periodFormatter == null) {
            return this.toString();
        }
        return periodFormatter.print(this);
    }
}

