/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.org.joda.time.chrono;

import codegurushadow.org.joda.time.Chronology;
import codegurushadow.org.joda.time.DateTimeField;
import codegurushadow.org.joda.time.DateTimeFieldType;
import codegurushadow.org.joda.time.DateTimeZone;
import codegurushadow.org.joda.time.DurationField;
import codegurushadow.org.joda.time.DurationFieldType;
import codegurushadow.org.joda.time.IllegalFieldValueException;
import codegurushadow.org.joda.time.ReadablePartial;
import codegurushadow.org.joda.time.ReadablePeriod;
import codegurushadow.org.joda.time.field.FieldUtils;
import codegurushadow.org.joda.time.field.UnsupportedDateTimeField;
import codegurushadow.org.joda.time.field.UnsupportedDurationField;
import java.io.Serializable;

public abstract class BaseChronology
extends Chronology
implements Serializable {
    private static final long serialVersionUID = -7310865996721419676L;

    protected BaseChronology() {
    }

    @Override
    public abstract DateTimeZone getZone();

    @Override
    public abstract Chronology withUTC();

    @Override
    public abstract Chronology withZone(DateTimeZone var1);

    @Override
    public long getDateTimeMillis(int n, int n2, int n3, int n4) throws IllegalArgumentException {
        long l = this.year().set(0L, n);
        l = this.monthOfYear().set(l, n2);
        l = this.dayOfMonth().set(l, n3);
        return this.millisOfDay().set(l, n4);
    }

    @Override
    public long getDateTimeMillis(int n, int n2, int n3, int n4, int n5, int n6, int n7) throws IllegalArgumentException {
        long l = this.year().set(0L, n);
        l = this.monthOfYear().set(l, n2);
        l = this.dayOfMonth().set(l, n3);
        l = this.hourOfDay().set(l, n4);
        l = this.minuteOfHour().set(l, n5);
        l = this.secondOfMinute().set(l, n6);
        return this.millisOfSecond().set(l, n7);
    }

    @Override
    public long getDateTimeMillis(long l, int n, int n2, int n3, int n4) throws IllegalArgumentException {
        l = this.hourOfDay().set(l, n);
        l = this.minuteOfHour().set(l, n2);
        l = this.secondOfMinute().set(l, n3);
        return this.millisOfSecond().set(l, n4);
    }

    @Override
    public void validate(ReadablePartial readablePartial, int[] nArray) {
        DateTimeField dateTimeField;
        int n;
        int n2;
        int n3 = readablePartial.size();
        for (n2 = 0; n2 < n3; ++n2) {
            n = nArray[n2];
            dateTimeField = readablePartial.getField(n2);
            if (n < dateTimeField.getMinimumValue()) {
                throw new IllegalFieldValueException(dateTimeField.getType(), (Number)n, (Number)dateTimeField.getMinimumValue(), null);
            }
            if (n <= dateTimeField.getMaximumValue()) continue;
            throw new IllegalFieldValueException(dateTimeField.getType(), (Number)n, null, (Number)dateTimeField.getMaximumValue());
        }
        for (n2 = 0; n2 < n3; ++n2) {
            n = nArray[n2];
            dateTimeField = readablePartial.getField(n2);
            if (n < dateTimeField.getMinimumValue(readablePartial, nArray)) {
                throw new IllegalFieldValueException(dateTimeField.getType(), (Number)n, (Number)dateTimeField.getMinimumValue(readablePartial, nArray), null);
            }
            if (n <= dateTimeField.getMaximumValue(readablePartial, nArray)) continue;
            throw new IllegalFieldValueException(dateTimeField.getType(), (Number)n, null, (Number)dateTimeField.getMaximumValue(readablePartial, nArray));
        }
    }

    @Override
    public int[] get(ReadablePartial readablePartial, long l) {
        int n = readablePartial.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = readablePartial.getFieldType(i).getField(this).get(l);
        }
        return nArray;
    }

    @Override
    public long set(ReadablePartial readablePartial, long l) {
        int n = readablePartial.size();
        for (int i = 0; i < n; ++i) {
            l = readablePartial.getFieldType(i).getField(this).set(l, readablePartial.getValue(i));
        }
        return l;
    }

    @Override
    public int[] get(ReadablePeriod readablePeriod, long l, long l2) {
        int n = readablePeriod.size();
        int[] nArray = new int[n];
        if (l != l2) {
            for (int i = 0; i < n; ++i) {
                DurationField durationField = readablePeriod.getFieldType(i).getField(this);
                int n2 = durationField.getDifference(l2, l);
                if (n2 != 0) {
                    l = durationField.add(l, n2);
                }
                nArray[i] = n2;
            }
        }
        return nArray;
    }

    @Override
    public int[] get(ReadablePeriod readablePeriod, long l) {
        int n = readablePeriod.size();
        int[] nArray = new int[n];
        if (l != 0L) {
            long l2 = 0L;
            for (int i = 0; i < n; ++i) {
                DurationField durationField = readablePeriod.getFieldType(i).getField(this);
                if (!durationField.isPrecise()) continue;
                int n2 = durationField.getDifference(l, l2);
                l2 = durationField.add(l2, n2);
                nArray[i] = n2;
            }
        }
        return nArray;
    }

    @Override
    public long add(ReadablePeriod readablePeriod, long l, int n) {
        if (n != 0 && readablePeriod != null) {
            int n2 = readablePeriod.size();
            for (int i = 0; i < n2; ++i) {
                long l2 = readablePeriod.getValue(i);
                if (l2 == 0L) continue;
                l = readablePeriod.getFieldType(i).getField(this).add(l, l2 * (long)n);
            }
        }
        return l;
    }

    @Override
    public long add(long l, long l2, int n) {
        if (l2 == 0L || n == 0) {
            return l;
        }
        long l3 = FieldUtils.safeMultiply(l2, n);
        return FieldUtils.safeAdd(l, l3);
    }

    @Override
    public DurationField millis() {
        return UnsupportedDurationField.getInstance(DurationFieldType.millis());
    }

    @Override
    public DateTimeField millisOfSecond() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.millisOfSecond(), this.millis());
    }

    @Override
    public DateTimeField millisOfDay() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.millisOfDay(), this.millis());
    }

    @Override
    public DurationField seconds() {
        return UnsupportedDurationField.getInstance(DurationFieldType.seconds());
    }

    @Override
    public DateTimeField secondOfMinute() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.secondOfMinute(), this.seconds());
    }

    @Override
    public DateTimeField secondOfDay() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.secondOfDay(), this.seconds());
    }

    @Override
    public DurationField minutes() {
        return UnsupportedDurationField.getInstance(DurationFieldType.minutes());
    }

    @Override
    public DateTimeField minuteOfHour() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.minuteOfHour(), this.minutes());
    }

    @Override
    public DateTimeField minuteOfDay() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.minuteOfDay(), this.minutes());
    }

    @Override
    public DurationField hours() {
        return UnsupportedDurationField.getInstance(DurationFieldType.hours());
    }

    @Override
    public DateTimeField hourOfDay() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.hourOfDay(), this.hours());
    }

    @Override
    public DateTimeField clockhourOfDay() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.clockhourOfDay(), this.hours());
    }

    @Override
    public DurationField halfdays() {
        return UnsupportedDurationField.getInstance(DurationFieldType.halfdays());
    }

    @Override
    public DateTimeField hourOfHalfday() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.hourOfHalfday(), this.hours());
    }

    @Override
    public DateTimeField clockhourOfHalfday() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.clockhourOfHalfday(), this.hours());
    }

    @Override
    public DateTimeField halfdayOfDay() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.halfdayOfDay(), this.halfdays());
    }

    @Override
    public DurationField days() {
        return UnsupportedDurationField.getInstance(DurationFieldType.days());
    }

    @Override
    public DateTimeField dayOfWeek() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.dayOfWeek(), this.days());
    }

    @Override
    public DateTimeField dayOfMonth() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.dayOfMonth(), this.days());
    }

    @Override
    public DateTimeField dayOfYear() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.dayOfYear(), this.days());
    }

    @Override
    public DurationField weeks() {
        return UnsupportedDurationField.getInstance(DurationFieldType.weeks());
    }

    @Override
    public DateTimeField weekOfWeekyear() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.weekOfWeekyear(), this.weeks());
    }

    @Override
    public DurationField weekyears() {
        return UnsupportedDurationField.getInstance(DurationFieldType.weekyears());
    }

    @Override
    public DateTimeField weekyear() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.weekyear(), this.weekyears());
    }

    @Override
    public DateTimeField weekyearOfCentury() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.weekyearOfCentury(), this.weekyears());
    }

    @Override
    public DurationField months() {
        return UnsupportedDurationField.getInstance(DurationFieldType.months());
    }

    @Override
    public DateTimeField monthOfYear() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.monthOfYear(), this.months());
    }

    @Override
    public DurationField years() {
        return UnsupportedDurationField.getInstance(DurationFieldType.years());
    }

    @Override
    public DateTimeField year() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.year(), this.years());
    }

    @Override
    public DateTimeField yearOfEra() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.yearOfEra(), this.years());
    }

    @Override
    public DateTimeField yearOfCentury() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.yearOfCentury(), this.years());
    }

    @Override
    public DurationField centuries() {
        return UnsupportedDurationField.getInstance(DurationFieldType.centuries());
    }

    @Override
    public DateTimeField centuryOfEra() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.centuryOfEra(), this.centuries());
    }

    @Override
    public DurationField eras() {
        return UnsupportedDurationField.getInstance(DurationFieldType.eras());
    }

    @Override
    public DateTimeField era() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.era(), this.eras());
    }

    @Override
    public abstract String toString();
}

