/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.org.joda.time.chrono;

import codegurushadow.org.joda.time.DateTimeFieldType;
import codegurushadow.org.joda.time.DurationField;
import codegurushadow.org.joda.time.ReadablePartial;
import codegurushadow.org.joda.time.chrono.BasicChronology;
import codegurushadow.org.joda.time.field.PreciseDurationDateTimeField;

final class BasicWeekOfWeekyearDateTimeField
extends PreciseDurationDateTimeField {
    private static final long serialVersionUID = -1587436826395135328L;
    private final BasicChronology iChronology;

    BasicWeekOfWeekyearDateTimeField(BasicChronology basicChronology, DurationField durationField) {
        super(DateTimeFieldType.weekOfWeekyear(), durationField);
        this.iChronology = basicChronology;
    }

    @Override
    public int get(long l) {
        return this.iChronology.getWeekOfWeekyear(l);
    }

    @Override
    public DurationField getRangeDurationField() {
        return this.iChronology.weekyears();
    }

    @Override
    public long roundFloor(long l) {
        return super.roundFloor(l + 259200000L) - 259200000L;
    }

    @Override
    public long roundCeiling(long l) {
        return super.roundCeiling(l + 259200000L) - 259200000L;
    }

    @Override
    public long remainder(long l) {
        return super.remainder(l + 259200000L);
    }

    @Override
    public int getMinimumValue() {
        return 1;
    }

    @Override
    public int getMaximumValue() {
        return 53;
    }

    @Override
    public int getMaximumValue(long l) {
        int n = this.iChronology.getWeekyear(l);
        return this.iChronology.getWeeksInYear(n);
    }

    @Override
    public int getMaximumValue(ReadablePartial readablePartial) {
        if (readablePartial.isSupported(DateTimeFieldType.weekyear())) {
            int n = readablePartial.get(DateTimeFieldType.weekyear());
            return this.iChronology.getWeeksInYear(n);
        }
        return 53;
    }

    @Override
    public int getMaximumValue(ReadablePartial readablePartial, int[] nArray) {
        int n = readablePartial.size();
        for (int i = 0; i < n; ++i) {
            if (readablePartial.getFieldType(i) != DateTimeFieldType.weekyear()) continue;
            int n2 = nArray[i];
            return this.iChronology.getWeeksInYear(n2);
        }
        return 53;
    }

    @Override
    protected int getMaximumValueForSet(long l, int n) {
        return n > 52 ? this.getMaximumValue(l) : 52;
    }

    private Object readResolve() {
        return this.iChronology.weekOfWeekyear();
    }
}

