/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.org.joda.time.chrono;

import codegurushadow.org.joda.time.DateTimeFieldType;
import codegurushadow.org.joda.time.DurationField;
import codegurushadow.org.joda.time.DurationFieldType;
import codegurushadow.org.joda.time.chrono.BasicChronology;
import codegurushadow.org.joda.time.chrono.GJLocaleSymbols;
import codegurushadow.org.joda.time.field.BaseDateTimeField;
import codegurushadow.org.joda.time.field.FieldUtils;
import codegurushadow.org.joda.time.field.UnsupportedDurationField;
import java.util.Locale;

final class GJEraDateTimeField
extends BaseDateTimeField {
    private static final long serialVersionUID = 4240986525305515528L;
    private final BasicChronology iChronology;

    GJEraDateTimeField(BasicChronology basicChronology) {
        super(DateTimeFieldType.era());
        this.iChronology = basicChronology;
    }

    @Override
    public boolean isLenient() {
        return false;
    }

    @Override
    public int get(long l) {
        if (this.iChronology.getYear(l) <= 0) {
            return 0;
        }
        return 1;
    }

    @Override
    public String getAsText(int n, Locale locale) {
        return GJLocaleSymbols.forLocale(locale).eraValueToText(n);
    }

    @Override
    public long set(long l, int n) {
        FieldUtils.verifyValueBounds(this, n, 0, 1);
        int n2 = this.get(l);
        if (n2 != n) {
            int n3 = this.iChronology.getYear(l);
            return this.iChronology.setYear(l, -n3);
        }
        return l;
    }

    @Override
    public long set(long l, String string, Locale locale) {
        return this.set(l, GJLocaleSymbols.forLocale(locale).eraTextToValue(string));
    }

    @Override
    public long roundFloor(long l) {
        if (this.get(l) == 1) {
            return this.iChronology.setYear(0L, 1);
        }
        return Long.MIN_VALUE;
    }

    @Override
    public long roundCeiling(long l) {
        if (this.get(l) == 0) {
            return this.iChronology.setYear(0L, 1);
        }
        return Long.MAX_VALUE;
    }

    @Override
    public long roundHalfFloor(long l) {
        return this.roundFloor(l);
    }

    @Override
    public long roundHalfCeiling(long l) {
        return this.roundFloor(l);
    }

    @Override
    public long roundHalfEven(long l) {
        return this.roundFloor(l);
    }

    @Override
    public DurationField getDurationField() {
        return UnsupportedDurationField.getInstance(DurationFieldType.eras());
    }

    @Override
    public DurationField getRangeDurationField() {
        return null;
    }

    @Override
    public int getMinimumValue() {
        return 0;
    }

    @Override
    public int getMaximumValue() {
        return 1;
    }

    @Override
    public int getMaximumTextLength(Locale locale) {
        return GJLocaleSymbols.forLocale(locale).getEraMaxTextLength();
    }

    private Object readResolve() {
        return this.iChronology.era();
    }
}

