/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.org.joda.time.convert;

import codegurushadow.org.joda.time.Chronology;
import codegurushadow.org.joda.time.DateTimeUtils;
import codegurushadow.org.joda.time.ReadWritableInterval;
import codegurushadow.org.joda.time.ReadWritablePeriod;
import codegurushadow.org.joda.time.ReadableInterval;
import codegurushadow.org.joda.time.convert.AbstractConverter;
import codegurushadow.org.joda.time.convert.DurationConverter;
import codegurushadow.org.joda.time.convert.IntervalConverter;
import codegurushadow.org.joda.time.convert.PeriodConverter;

class ReadableIntervalConverter
extends AbstractConverter
implements IntervalConverter,
DurationConverter,
PeriodConverter {
    static final ReadableIntervalConverter INSTANCE = new ReadableIntervalConverter();

    protected ReadableIntervalConverter() {
    }

    @Override
    public long getDurationMillis(Object object) {
        return ((ReadableInterval)object).toDurationMillis();
    }

    @Override
    public void setInto(ReadWritablePeriod readWritablePeriod, Object object, Chronology chronology) {
        ReadableInterval readableInterval = (ReadableInterval)object;
        chronology = chronology != null ? chronology : DateTimeUtils.getIntervalChronology(readableInterval);
        long l = readableInterval.getStartMillis();
        long l2 = readableInterval.getEndMillis();
        int[] nArray = chronology.get(readWritablePeriod, l, l2);
        for (int i = 0; i < nArray.length; ++i) {
            readWritablePeriod.setValue(i, nArray[i]);
        }
    }

    @Override
    public boolean isReadableInterval(Object object, Chronology chronology) {
        return true;
    }

    @Override
    public void setInto(ReadWritableInterval readWritableInterval, Object object, Chronology chronology) {
        ReadableInterval readableInterval = (ReadableInterval)object;
        readWritableInterval.setInterval(readableInterval);
        if (chronology != null) {
            readWritableInterval.setChronology(chronology);
        } else {
            readWritableInterval.setChronology(readableInterval.getChronology());
        }
    }

    @Override
    public Class<?> getSupportedType() {
        return ReadableInterval.class;
    }
}

