/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.org.joda.time.field;

import codegurushadow.org.joda.time.DurationField;
import codegurushadow.org.joda.time.DurationFieldType;
import codegurushadow.org.joda.time.field.FieldUtils;
import java.io.Serializable;

public abstract class BaseDurationField
extends DurationField
implements Serializable {
    private static final long serialVersionUID = -2554245107589433218L;
    private final DurationFieldType iType;

    protected BaseDurationField(DurationFieldType durationFieldType) {
        if (durationFieldType == null) {
            throw new IllegalArgumentException("The type must not be null");
        }
        this.iType = durationFieldType;
    }

    @Override
    public final DurationFieldType getType() {
        return this.iType;
    }

    @Override
    public final String getName() {
        return this.iType.getName();
    }

    @Override
    public final boolean isSupported() {
        return true;
    }

    @Override
    public int getValue(long l) {
        return FieldUtils.safeToInt(this.getValueAsLong(l));
    }

    @Override
    public long getValueAsLong(long l) {
        return l / this.getUnitMillis();
    }

    @Override
    public int getValue(long l, long l2) {
        return FieldUtils.safeToInt(this.getValueAsLong(l, l2));
    }

    @Override
    public long getMillis(int n) {
        return (long)n * this.getUnitMillis();
    }

    @Override
    public long getMillis(long l) {
        return FieldUtils.safeMultiply(l, this.getUnitMillis());
    }

    @Override
    public int getDifference(long l, long l2) {
        return FieldUtils.safeToInt(this.getDifferenceAsLong(l, l2));
    }

    @Override
    public int compareTo(DurationField durationField) {
        long l = durationField.getUnitMillis();
        long l2 = this.getUnitMillis();
        if (l2 == l) {
            return 0;
        }
        if (l2 < l) {
            return -1;
        }
        return 1;
    }

    @Override
    public String toString() {
        return "DurationField[" + this.getName() + ']';
    }
}

