/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.org.joda.time.field;

import codegurushadow.org.joda.time.DurationField;
import codegurushadow.org.joda.time.DurationFieldType;
import codegurushadow.org.joda.time.field.FieldUtils;
import java.io.Serializable;

public final class MillisDurationField
extends DurationField
implements Serializable {
    private static final long serialVersionUID = 2656707858124633367L;
    public static final DurationField INSTANCE = new MillisDurationField();

    private MillisDurationField() {
    }

    @Override
    public DurationFieldType getType() {
        return DurationFieldType.millis();
    }

    @Override
    public String getName() {
        return "millis";
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public final boolean isPrecise() {
        return true;
    }

    @Override
    public final long getUnitMillis() {
        return 1L;
    }

    @Override
    public int getValue(long l) {
        return FieldUtils.safeToInt(l);
    }

    @Override
    public long getValueAsLong(long l) {
        return l;
    }

    @Override
    public int getValue(long l, long l2) {
        return FieldUtils.safeToInt(l);
    }

    @Override
    public long getValueAsLong(long l, long l2) {
        return l;
    }

    @Override
    public long getMillis(int n) {
        return n;
    }

    @Override
    public long getMillis(long l) {
        return l;
    }

    @Override
    public long getMillis(int n, long l) {
        return n;
    }

    @Override
    public long getMillis(long l, long l2) {
        return l;
    }

    @Override
    public long add(long l, int n) {
        return FieldUtils.safeAdd(l, (long)n);
    }

    @Override
    public long add(long l, long l2) {
        return FieldUtils.safeAdd(l, l2);
    }

    @Override
    public int getDifference(long l, long l2) {
        return FieldUtils.safeToInt(FieldUtils.safeSubtract(l, l2));
    }

    @Override
    public long getDifferenceAsLong(long l, long l2) {
        return FieldUtils.safeSubtract(l, l2);
    }

    @Override
    public int compareTo(DurationField durationField) {
        long l = durationField.getUnitMillis();
        long l2 = this.getUnitMillis();
        if (l2 == l) {
            return 0;
        }
        if (l2 < l) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object object) {
        if (object instanceof MillisDurationField) {
            return this.getUnitMillis() == ((MillisDurationField)object).getUnitMillis();
        }
        return false;
    }

    public int hashCode() {
        return (int)this.getUnitMillis();
    }

    @Override
    public String toString() {
        return "DurationField[millis]";
    }

    private Object readResolve() {
        return INSTANCE;
    }
}

