/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.auth.credentials.internal;

import codegurushadow.software.amazon.awssdk.annotations.SdkInternalApi;
import codegurushadow.software.amazon.awssdk.http.HttpStatusFamily;
import codegurushadow.software.amazon.awssdk.regions.util.ResourcesEndpointRetryParameters;
import codegurushadow.software.amazon.awssdk.regions.util.ResourcesEndpointRetryPolicy;
import java.io.IOException;

@SdkInternalApi
public final class ContainerCredentialsRetryPolicy
implements ResourcesEndpointRetryPolicy {
    private static final int MAX_RETRIES = 5;

    @Override
    public boolean shouldRetry(int retriesAttempted, ResourcesEndpointRetryParameters retryParams) {
        if (retriesAttempted >= 5) {
            return false;
        }
        Integer statusCode = retryParams.getStatusCode();
        if (statusCode != null && HttpStatusFamily.of(statusCode) == HttpStatusFamily.SERVER_ERROR) {
            return true;
        }
        return retryParams.getException() instanceof IOException;
    }
}

