/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.auth.credentials.internal;

import codegurushadow.software.amazon.awssdk.annotations.SdkInternalApi;
import codegurushadow.software.amazon.awssdk.regions.util.ResourcesEndpointProvider;
import codegurushadow.software.amazon.awssdk.utils.Validate;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Map;

@SdkInternalApi
public final class StaticResourcesEndpointProvider
implements ResourcesEndpointProvider {
    private final URI endpoint;
    private final Map<String, String> headers;

    public StaticResourcesEndpointProvider(URI endpoint, Map<String, String> additionalHeaders) {
        this.endpoint = Validate.paramNotNull(endpoint, "endpoint");
        this.headers = ResourcesEndpointProvider.super.headers();
        if (additionalHeaders != null) {
            this.headers.putAll(additionalHeaders);
        }
    }

    @Override
    public URI endpoint() throws IOException {
        return this.endpoint;
    }

    @Override
    public Map<String, String> headers() {
        return Collections.unmodifiableMap(this.headers);
    }
}

