/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.auth.signer.internal;

import codegurushadow.software.amazon.awssdk.annotations.SdkInternalApi;
import codegurushadow.software.amazon.awssdk.core.exception.SdkClientException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;

@SdkInternalApi
public enum SigningAlgorithm {
    HmacSHA256;

    private final ThreadLocal<Mac> macReference;

    private SigningAlgorithm() {
        String algorithmName = this.toString();
        this.macReference = new MacThreadLocal(algorithmName);
    }

    public Mac getMac() {
        return this.macReference.get();
    }

    private static class MacThreadLocal
    extends ThreadLocal<Mac> {
        private final String algorithmName;

        MacThreadLocal(String algorithmName) {
            this.algorithmName = algorithmName;
        }

        @Override
        protected Mac initialValue() {
            try {
                return Mac.getInstance(this.algorithmName);
            }
            catch (NoSuchAlgorithmException e) {
                throw SdkClientException.builder().message("Unable to fetch Mac instance for Algorithm " + this.algorithmName + e.getMessage()).cause(e).build();
            }
        }
    }
}

