/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.auth.token.credentials;

import codegurushadow.software.amazon.awssdk.annotations.SdkPublicApi;
import codegurushadow.software.amazon.awssdk.annotations.SdkTestInternalApi;
import codegurushadow.software.amazon.awssdk.auth.token.credentials.SdkToken;
import codegurushadow.software.amazon.awssdk.auth.token.credentials.SdkTokenProvider;
import codegurushadow.software.amazon.awssdk.auth.token.internal.ProfileTokenProviderLoader;
import codegurushadow.software.amazon.awssdk.core.exception.SdkClientException;
import codegurushadow.software.amazon.awssdk.profiles.Profile;
import codegurushadow.software.amazon.awssdk.profiles.ProfileFile;
import codegurushadow.software.amazon.awssdk.profiles.ProfileFileSystemSetting;
import codegurushadow.software.amazon.awssdk.utils.IoUtils;
import codegurushadow.software.amazon.awssdk.utils.SdkAutoCloseable;
import codegurushadow.software.amazon.awssdk.utils.ToString;
import java.util.Optional;
import java.util.function.Supplier;

@SdkPublicApi
public final class ProfileTokenProvider
implements SdkTokenProvider,
SdkAutoCloseable {
    private final SdkTokenProvider tokenProvider;
    private final RuntimeException loadException;
    private final ProfileFile profileFile;
    private final String profileName;

    private ProfileTokenProvider(BuilderImpl builder) {
        SdkTokenProvider tokenProvider = null;
        RuntimeException loadException = null;
        ProfileFile profileFile = null;
        String profileName = null;
        try {
            profileName = builder.profileName != null ? builder.profileName : ProfileFileSystemSetting.AWS_PROFILE.getStringValueOrThrow();
            profileFile = (ProfileFile)Optional.ofNullable(builder.profileFile).orElse(builder.defaultProfileFileLoader).get();
            String finalProfileName = profileName;
            ProfileFile finalProfileFile = profileFile;
            tokenProvider = (SdkTokenProvider)profileFile.profile(profileName).flatMap(p -> new ProfileTokenProviderLoader(finalProfileFile, (Profile)p).tokenProvider()).orElseThrow(() -> {
                String errorMessage = String.format("Profile file contained no information for profile '%s': %s", finalProfileName, finalProfileFile);
                return SdkClientException.builder().message(errorMessage).build();
            });
        }
        catch (RuntimeException e) {
            loadException = e;
        }
        if (loadException != null) {
            this.loadException = loadException;
            this.tokenProvider = null;
            this.profileFile = null;
            this.profileName = null;
        } else {
            this.loadException = null;
            this.tokenProvider = tokenProvider;
            this.profileFile = profileFile;
            this.profileName = profileName;
        }
    }

    public static ProfileTokenProvider create() {
        return ProfileTokenProvider.builder().build();
    }

    public static ProfileTokenProvider create(String profileName) {
        return ProfileTokenProvider.builder().profileName(profileName).build();
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    @Override
    public SdkToken resolveToken() {
        if (this.loadException != null) {
            throw this.loadException;
        }
        return this.tokenProvider.resolveToken();
    }

    public String toString() {
        return ToString.builder("ProfileTokenProvider").add("profileName", this.profileName).add("profileFile", this.profileFile).build();
    }

    @Override
    public void close() {
        IoUtils.closeIfCloseable(this.tokenProvider, null);
    }

    static final class BuilderImpl
    implements Builder {
        private Supplier<ProfileFile> profileFile;
        private String profileName;
        private Supplier<ProfileFile> defaultProfileFileLoader = ProfileFile::defaultProfileFile;

        BuilderImpl() {
        }

        @Override
        public Builder profileFile(Supplier<ProfileFile> profileFile) {
            this.profileFile = profileFile;
            return this;
        }

        public void setProfileFile(Supplier<ProfileFile> profileFile) {
            this.profileFile(profileFile);
        }

        @Override
        public Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public void setProfileName(String profileName) {
            this.profileName(profileName);
        }

        @Override
        public ProfileTokenProvider build() {
            return new ProfileTokenProvider(this);
        }

        @SdkTestInternalApi
        Builder defaultProfileFileLoader(Supplier<ProfileFile> defaultProfileFileLoader) {
            this.defaultProfileFileLoader = defaultProfileFileLoader;
            return this;
        }
    }

    public static interface Builder {
        public Builder profileFile(Supplier<ProfileFile> var1);

        public Builder profileName(String var1);

        public ProfileTokenProvider build();
    }
}

