/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.auth.token.credentials.aws;

import codegurushadow.software.amazon.awssdk.annotations.SdkPublicApi;
import codegurushadow.software.amazon.awssdk.auth.token.credentials.ProfileTokenProvider;
import codegurushadow.software.amazon.awssdk.auth.token.credentials.SdkToken;
import codegurushadow.software.amazon.awssdk.auth.token.credentials.SdkTokenProvider;
import codegurushadow.software.amazon.awssdk.auth.token.credentials.SdkTokenProviderChain;
import codegurushadow.software.amazon.awssdk.auth.token.internal.LazyTokenProvider;
import codegurushadow.software.amazon.awssdk.profiles.ProfileFile;
import codegurushadow.software.amazon.awssdk.utils.SdkAutoCloseable;
import codegurushadow.software.amazon.awssdk.utils.ToString;
import java.util.function.Supplier;

@SdkPublicApi
public final class DefaultAwsTokenProvider
implements SdkTokenProvider,
SdkAutoCloseable {
    private static final DefaultAwsTokenProvider DEFAULT_TOKEN_PROVIDER = new DefaultAwsTokenProvider(DefaultAwsTokenProvider.builder());
    private final LazyTokenProvider providerChain;

    private DefaultAwsTokenProvider(Builder builder) {
        this.providerChain = DefaultAwsTokenProvider.createChain(builder);
    }

    public static DefaultAwsTokenProvider create() {
        return DEFAULT_TOKEN_PROVIDER;
    }

    private static LazyTokenProvider createChain(Builder builder) {
        return LazyTokenProvider.create(() -> SdkTokenProviderChain.of(ProfileTokenProvider.builder().profileFile(builder.profileFile).profileName(builder.profileName).build()));
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public SdkToken resolveToken() {
        return this.providerChain.resolveToken();
    }

    @Override
    public void close() {
        this.providerChain.close();
    }

    public String toString() {
        return ToString.builder("DefaultAwsTokenProvider").add("providerChain", this.providerChain).build();
    }

    public static final class Builder {
        private Supplier<ProfileFile> profileFile;
        private String profileName;

        private Builder() {
        }

        public Builder profileFile(Supplier<ProfileFile> profileFile) {
            this.profileFile = profileFile;
            return this;
        }

        public Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public DefaultAwsTokenProvider build() {
            return new DefaultAwsTokenProvider(this);
        }
    }
}

