/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.auth.token.internal;

import codegurushadow.software.amazon.awssdk.annotations.SdkInternalApi;
import codegurushadow.software.amazon.awssdk.auth.token.credentials.SdkToken;
import codegurushadow.software.amazon.awssdk.auth.token.credentials.SdkTokenProvider;
import codegurushadow.software.amazon.awssdk.utils.IoUtils;
import codegurushadow.software.amazon.awssdk.utils.Lazy;
import codegurushadow.software.amazon.awssdk.utils.SdkAutoCloseable;
import codegurushadow.software.amazon.awssdk.utils.ToString;
import java.util.function.Supplier;

@SdkInternalApi
public class LazyTokenProvider
implements SdkTokenProvider,
SdkAutoCloseable {
    private final Lazy<SdkTokenProvider> delegate;

    public LazyTokenProvider(Supplier<SdkTokenProvider> delegateConstructor) {
        this.delegate = new Lazy<SdkTokenProvider>(delegateConstructor);
    }

    public static LazyTokenProvider create(Supplier<SdkTokenProvider> delegateConstructor) {
        return new LazyTokenProvider(delegateConstructor);
    }

    @Override
    public SdkToken resolveToken() {
        return this.delegate.getValue().resolveToken();
    }

    @Override
    public void close() {
        IoUtils.closeIfCloseable(this.delegate, null);
    }

    public String toString() {
        return ToString.builder("LazyTokenProvider").add("delegate", this.delegate).build();
    }
}

