/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.auth.token.internal;

import codegurushadow.software.amazon.awssdk.annotations.SdkInternalApi;
import codegurushadow.software.amazon.awssdk.auth.token.credentials.ChildProfileTokenProviderFactory;
import codegurushadow.software.amazon.awssdk.auth.token.credentials.SdkTokenProvider;
import codegurushadow.software.amazon.awssdk.core.internal.util.ClassLoaderHelper;
import codegurushadow.software.amazon.awssdk.profiles.Profile;
import codegurushadow.software.amazon.awssdk.profiles.ProfileFile;
import codegurushadow.software.amazon.awssdk.profiles.internal.ProfileSection;
import codegurushadow.software.amazon.awssdk.utils.Validate;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Optional;

@SdkInternalApi
public final class ProfileTokenProviderLoader {
    private static final String SSO_OIDC_TOKEN_PROVIDER_FACTORY = "software.amazon.awssdk.services.ssooidc.SsoOidcProfileTokenProviderFactory";
    private final Profile profile;
    private final ProfileFile profileFile;

    public ProfileTokenProviderLoader(ProfileFile profileFile, Profile profile) {
        this.profile = Validate.paramNotNull(profile, "profile");
        this.profileFile = Validate.paramNotNull(profileFile, "profileFile");
    }

    public Optional<SdkTokenProvider> tokenProvider() {
        return Optional.ofNullable(this.ssoProfileCredentialsProvider());
    }

    private SdkTokenProvider ssoProfileCredentialsProvider() {
        String profileSsoSectionName = this.profile.property(ProfileSection.SSO_SESSION.getPropertyKeyName()).orElseThrow(() -> new IllegalArgumentException("Profile " + this.profile.name() + " does not have sso_session property"));
        Profile ssoProfile = this.profileFile.getSection(ProfileSection.SSO_SESSION.getSectionTitle(), profileSsoSectionName).orElseThrow(() -> new IllegalArgumentException("Sso-session section not found with sso-session title " + profileSsoSectionName));
        this.validateRequiredProperties(ssoProfile, "sso_region", "sso_start_url");
        return this.ssoTokenProviderFactory().create(this.profileFile, this.profile);
    }

    private void validateRequiredProperties(Profile ssoProfile, String ... requiredProperties) {
        Arrays.stream(requiredProperties).forEach(p -> Validate.isTrue(ssoProfile.properties().containsKey(p), "Property '%s' was not configured for profile '%s'.", p, this.profile.name()));
    }

    private ChildProfileTokenProviderFactory ssoTokenProviderFactory() {
        try {
            Class<?> ssoOidcTokenProviderFactory = ClassLoaderHelper.loadClass(SSO_OIDC_TOKEN_PROVIDER_FACTORY, this.getClass());
            return (ChildProfileTokenProviderFactory)ssoOidcTokenProviderFactory.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("To use SSO OIDC related properties in the '" + this.profile.name() + "' profile, the 'ssooidc' service module must be on the class path.", e);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Failed to create the '" + this.profile.name() + "' token provider factory.", e);
        }
    }
}

