/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.awscore.interceptor;

import codegurushadow.software.amazon.awssdk.annotations.SdkInternalApi;
import codegurushadow.software.amazon.awssdk.core.interceptor.Context;
import codegurushadow.software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import codegurushadow.software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import codegurushadow.software.amazon.awssdk.http.SdkHttpRequest;
import codegurushadow.software.amazon.awssdk.utils.SystemSetting;
import java.util.Optional;

@SdkInternalApi
public class TraceIdExecutionInterceptor
implements ExecutionInterceptor {
    private static final String TRACE_ID_HEADER = "X-Amzn-Trace-Id";
    private static final String TRACE_ID_ENVIRONMENT_VARIABLE = "_X_AMZN_TRACE_ID";
    private static final String LAMBDA_FUNCTION_NAME_ENVIRONMENT_VARIABLE = "AWS_LAMBDA_FUNCTION_NAME";

    @Override
    public SdkHttpRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        Optional<String> traceIdHeader = this.traceIdHeader(context);
        if (!traceIdHeader.isPresent()) {
            Optional<String> lambdafunctionName = this.lambdaFunctionNameEnvironmentVariable();
            Optional<String> traceId = this.traceIdEnvironmentVariable();
            if (lambdafunctionName.isPresent() && traceId.isPresent()) {
                return (SdkHttpRequest)context.httpRequest().copy(r -> r.putHeader(TRACE_ID_HEADER, (String)traceId.get()));
            }
        }
        return context.httpRequest();
    }

    private Optional<String> traceIdHeader(Context.ModifyHttpRequest context) {
        return context.httpRequest().firstMatchingHeader(TRACE_ID_HEADER);
    }

    private Optional<String> traceIdEnvironmentVariable() {
        return SystemSetting.getStringValueFromEnvironmentVariable(TRACE_ID_ENVIRONMENT_VARIABLE);
    }

    private Optional<String> lambdaFunctionNameEnvironmentVariable() {
        return SystemSetting.getStringValueFromEnvironmentVariable(LAMBDA_FUNCTION_NAME_ENVIRONMENT_VARIABLE);
    }
}

