/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.awscore.internal.authcontext;

import codegurushadow.software.amazon.awssdk.annotations.SdkInternalApi;
import codegurushadow.software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import codegurushadow.software.amazon.awssdk.auth.token.credentials.SdkTokenProvider;
import codegurushadow.software.amazon.awssdk.awscore.client.config.AwsClientOption;
import codegurushadow.software.amazon.awssdk.awscore.internal.authcontext.AuthorizationStrategy;
import codegurushadow.software.amazon.awssdk.awscore.internal.authcontext.AwsCredentialsAuthorizationStrategy;
import codegurushadow.software.amazon.awssdk.awscore.internal.authcontext.TokenAuthorizationStrategy;
import codegurushadow.software.amazon.awssdk.core.CredentialType;
import codegurushadow.software.amazon.awssdk.core.SdkRequest;
import codegurushadow.software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import codegurushadow.software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import codegurushadow.software.amazon.awssdk.core.signer.Signer;
import codegurushadow.software.amazon.awssdk.metrics.MetricCollector;

@SdkInternalApi
public final class AuthorizationStrategyFactory {
    private final SdkRequest request;
    private final MetricCollector metricCollector;
    private final SdkClientConfiguration clientConfiguration;

    public AuthorizationStrategyFactory(SdkRequest request, MetricCollector metricCollector, SdkClientConfiguration clientConfiguration) {
        this.request = request;
        this.metricCollector = metricCollector;
        this.clientConfiguration = clientConfiguration;
    }

    public AuthorizationStrategy strategyFor(CredentialType credentialType) {
        if (credentialType == CredentialType.TOKEN) {
            return this.tokenAuthorizationStrategy();
        }
        return this.awsCredentialsAuthorizationStrategy();
    }

    private TokenAuthorizationStrategy tokenAuthorizationStrategy() {
        Signer defaultSigner = this.clientConfiguration.option(SdkAdvancedClientOption.TOKEN_SIGNER);
        SdkTokenProvider defaultTokenProvider = this.clientConfiguration.option(AwsClientOption.TOKEN_PROVIDER);
        return TokenAuthorizationStrategy.builder().request(this.request).defaultSigner(defaultSigner).defaultTokenProvider(defaultTokenProvider).metricCollector(this.metricCollector).build();
    }

    private AwsCredentialsAuthorizationStrategy awsCredentialsAuthorizationStrategy() {
        Signer defaultSigner = this.clientConfiguration.option(SdkAdvancedClientOption.SIGNER);
        AwsCredentialsProvider defaultCredentialsProvider = this.clientConfiguration.option(AwsClientOption.CREDENTIALS_PROVIDER);
        return AwsCredentialsAuthorizationStrategy.builder().request(this.request).defaultSigner(defaultSigner).defaultCredentialsProvider(defaultCredentialsProvider).metricCollector(this.metricCollector).build();
    }
}

