/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.awscore.internal.defaultsmode;

import codegurushadow.software.amazon.awssdk.annotations.SdkInternalApi;
import codegurushadow.software.amazon.awssdk.awscore.defaultsmode.DefaultsMode;
import codegurushadow.software.amazon.awssdk.core.client.config.SdkClientOption;
import codegurushadow.software.amazon.awssdk.core.retry.RetryMode;
import codegurushadow.software.amazon.awssdk.http.SdkHttpConfigurationOption;
import codegurushadow.software.amazon.awssdk.regions.ServiceMetadataAdvancedOption;
import codegurushadow.software.amazon.awssdk.utils.AttributeMap;
import java.time.Duration;
import java.util.EnumMap;
import java.util.Map;

@SdkInternalApi
public final class DefaultsModeConfiguration {
    private static final AttributeMap STANDARD_DEFAULTS = AttributeMap.builder().put(SdkClientOption.DEFAULT_RETRY_MODE, RetryMode.STANDARD).put(ServiceMetadataAdvancedOption.DEFAULT_S3_US_EAST_1_REGIONAL_ENDPOINT, "regional").build();
    private static final AttributeMap STANDARD_HTTP_DEFAULTS = AttributeMap.builder().put(SdkHttpConfigurationOption.CONNECTION_TIMEOUT, Duration.ofMillis(3100L)).put(SdkHttpConfigurationOption.TLS_NEGOTIATION_TIMEOUT, Duration.ofMillis(3100L)).build();
    private static final AttributeMap MOBILE_DEFAULTS = AttributeMap.builder().put(SdkClientOption.DEFAULT_RETRY_MODE, RetryMode.STANDARD).put(ServiceMetadataAdvancedOption.DEFAULT_S3_US_EAST_1_REGIONAL_ENDPOINT, "regional").build();
    private static final AttributeMap MOBILE_HTTP_DEFAULTS = AttributeMap.builder().put(SdkHttpConfigurationOption.CONNECTION_TIMEOUT, Duration.ofMillis(30000L)).put(SdkHttpConfigurationOption.TLS_NEGOTIATION_TIMEOUT, Duration.ofMillis(30000L)).build();
    private static final AttributeMap CROSS_REGION_DEFAULTS = AttributeMap.builder().put(SdkClientOption.DEFAULT_RETRY_MODE, RetryMode.STANDARD).put(ServiceMetadataAdvancedOption.DEFAULT_S3_US_EAST_1_REGIONAL_ENDPOINT, "regional").build();
    private static final AttributeMap CROSS_REGION_HTTP_DEFAULTS = AttributeMap.builder().put(SdkHttpConfigurationOption.CONNECTION_TIMEOUT, Duration.ofMillis(3100L)).put(SdkHttpConfigurationOption.TLS_NEGOTIATION_TIMEOUT, Duration.ofMillis(3100L)).build();
    private static final AttributeMap IN_REGION_DEFAULTS = AttributeMap.builder().put(SdkClientOption.DEFAULT_RETRY_MODE, RetryMode.STANDARD).put(ServiceMetadataAdvancedOption.DEFAULT_S3_US_EAST_1_REGIONAL_ENDPOINT, "regional").build();
    private static final AttributeMap IN_REGION_HTTP_DEFAULTS = AttributeMap.builder().put(SdkHttpConfigurationOption.CONNECTION_TIMEOUT, Duration.ofMillis(1100L)).put(SdkHttpConfigurationOption.TLS_NEGOTIATION_TIMEOUT, Duration.ofMillis(1100L)).build();
    private static final AttributeMap LEGACY_DEFAULTS = AttributeMap.empty();
    private static final AttributeMap LEGACY_HTTP_DEFAULTS = AttributeMap.empty();
    private static final Map<DefaultsMode, AttributeMap> DEFAULT_CONFIG_BY_MODE = new EnumMap<DefaultsMode, AttributeMap>(DefaultsMode.class);
    private static final Map<DefaultsMode, AttributeMap> DEFAULT_HTTP_CONFIG_BY_MODE = new EnumMap<DefaultsMode, AttributeMap>(DefaultsMode.class);

    private DefaultsModeConfiguration() {
    }

    public static AttributeMap defaultConfig(DefaultsMode mode) {
        return DEFAULT_CONFIG_BY_MODE.getOrDefault((Object)mode, AttributeMap.empty());
    }

    public static AttributeMap defaultHttpConfig(DefaultsMode mode) {
        return DEFAULT_HTTP_CONFIG_BY_MODE.getOrDefault((Object)mode, AttributeMap.empty());
    }

    static {
        DEFAULT_CONFIG_BY_MODE.put(DefaultsMode.STANDARD, STANDARD_DEFAULTS);
        DEFAULT_CONFIG_BY_MODE.put(DefaultsMode.MOBILE, MOBILE_DEFAULTS);
        DEFAULT_CONFIG_BY_MODE.put(DefaultsMode.CROSS_REGION, CROSS_REGION_DEFAULTS);
        DEFAULT_CONFIG_BY_MODE.put(DefaultsMode.IN_REGION, IN_REGION_DEFAULTS);
        DEFAULT_CONFIG_BY_MODE.put(DefaultsMode.LEGACY, LEGACY_DEFAULTS);
        DEFAULT_HTTP_CONFIG_BY_MODE.put(DefaultsMode.STANDARD, STANDARD_HTTP_DEFAULTS);
        DEFAULT_HTTP_CONFIG_BY_MODE.put(DefaultsMode.MOBILE, MOBILE_HTTP_DEFAULTS);
        DEFAULT_HTTP_CONFIG_BY_MODE.put(DefaultsMode.CROSS_REGION, CROSS_REGION_HTTP_DEFAULTS);
        DEFAULT_HTTP_CONFIG_BY_MODE.put(DefaultsMode.IN_REGION, IN_REGION_HTTP_DEFAULTS);
        DEFAULT_HTTP_CONFIG_BY_MODE.put(DefaultsMode.LEGACY, LEGACY_HTTP_DEFAULTS);
    }
}

