/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.awscore.util;

import codegurushadow.software.amazon.awssdk.annotations.SdkProtectedApi;
import codegurushadow.software.amazon.awssdk.awscore.AwsRequest;
import codegurushadow.software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import codegurushadow.software.amazon.awssdk.core.RequestOverrideConfiguration;
import codegurushadow.software.amazon.awssdk.core.SdkRequest;
import codegurushadow.software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import codegurushadow.software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import codegurushadow.software.amazon.awssdk.core.signer.Signer;
import java.util.Optional;
import java.util.function.Supplier;

@SdkProtectedApi
public final class SignerOverrideUtils {
    private SignerOverrideUtils() {
    }

    public static SdkRequest overrideSignerIfNotOverridden(SdkRequest request, ExecutionAttributes executionAttributes, Signer signer) {
        return SignerOverrideUtils.overrideSignerIfNotOverridden(request, executionAttributes, () -> signer);
    }

    public static SdkRequest overrideSignerIfNotOverridden(SdkRequest request, ExecutionAttributes executionAttributes, Supplier<Signer> signer) {
        if (SignerOverrideUtils.isSignerOverridden(request, executionAttributes)) {
            return request;
        }
        return SignerOverrideUtils.overrideSigner(request, signer.get());
    }

    private static boolean isSignerOverridden(SdkRequest request, ExecutionAttributes executionAttributes) {
        Optional<Boolean> isClientSignerOverridden = Optional.ofNullable(executionAttributes.getAttribute(SdkExecutionAttribute.SIGNER_OVERRIDDEN));
        Optional requestSigner = request.overrideConfiguration().flatMap(RequestOverrideConfiguration::signer);
        return isClientSignerOverridden.isPresent() || requestSigner.isPresent();
    }

    private static SdkRequest overrideSigner(SdkRequest request, Signer signer) {
        return request.overrideConfiguration().flatMap(config -> config.signer().map(existingOverrideSigner -> request)).orElseGet(() -> SignerOverrideUtils.createNewRequest(request, signer));
    }

    private static SdkRequest createNewRequest(SdkRequest request, Signer signer) {
        AwsRequest awsRequest = (AwsRequest)request;
        AwsRequestOverrideConfiguration modifiedOverride = ((AwsRequestOverrideConfiguration.Builder)awsRequest.overrideConfiguration().map(AwsRequestOverrideConfiguration::toBuilder).orElseGet(AwsRequestOverrideConfiguration::builder).signer(signer)).build();
        return awsRequest.toBuilder().overrideConfiguration(modifiedOverride).build();
    }
}

