/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.core.async.listener;

import codegurushadow.org.reactivestreams.Subscriber;
import codegurushadow.software.amazon.awssdk.annotations.SdkInternalApi;
import codegurushadow.software.amazon.awssdk.annotations.SdkProtectedApi;
import codegurushadow.software.amazon.awssdk.core.async.SdkPublisher;
import codegurushadow.software.amazon.awssdk.core.async.listener.SubscriberListener;
import codegurushadow.software.amazon.awssdk.utils.Logger;
import codegurushadow.software.amazon.awssdk.utils.Validate;

@SdkProtectedApi
public interface PublisherListener<T>
extends SubscriberListener<T> {
    default public void publisherSubscribe(Subscriber<? super T> subscriber) {
    }

    public static <T> SdkPublisher<T> wrap(SdkPublisher<T> delegate, PublisherListener<T> listener) {
        return new NotifyingPublisher<T>(delegate, listener);
    }

    @SdkInternalApi
    public static final class NotifyingPublisher<T>
    implements SdkPublisher<T> {
        private static final Logger log = Logger.loggerFor(NotifyingPublisher.class);
        private final SdkPublisher<T> delegate;
        private final PublisherListener<T> listener;

        NotifyingPublisher(SdkPublisher<T> delegate, PublisherListener<T> listener) {
            this.delegate = Validate.notNull(delegate, "delegate", new Object[0]);
            this.listener = Validate.notNull(listener, "listener", new Object[0]);
        }

        @Override
        public void subscribe(Subscriber<? super T> s) {
            NotifyingPublisher.invoke(() -> this.listener.publisherSubscribe(s), "publisherSubscribe");
            this.delegate.subscribe(SubscriberListener.wrap(s, this.listener));
        }

        static void invoke(Runnable runnable, String callbackName) {
            try {
                runnable.run();
            }
            catch (Exception e) {
                log.error(() -> callbackName + " callback failed. This exception will be dropped.", e);
            }
        }
    }
}

