/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.core.checksums;

import codegurushadow.software.amazon.awssdk.annotations.SdkInternalApi;
import codegurushadow.software.amazon.awssdk.core.checksums.SdkChecksum;
import java.security.MessageDigest;

@SdkInternalApi
public class Md5Checksum
implements SdkChecksum {
    private MessageDigest digest = this.getDigest();
    private MessageDigest digestLastMarked;

    @Override
    public void update(int b) {
        this.digest.update((byte)b);
    }

    @Override
    public void update(byte[] b, int off, int len) {
        this.digest.update(b, off, len);
    }

    @Override
    public long getValue() {
        throw new UnsupportedOperationException("Use getChecksumBytes() instead.");
    }

    @Override
    public void reset() {
        this.digest = this.digestLastMarked == null ? this.getDigest() : this.cloneFrom(this.digestLastMarked);
    }

    private MessageDigest getDigest() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            throw new IllegalStateException("Unexpected error creating MD5 checksum", e);
        }
    }

    @Override
    public byte[] getChecksumBytes() {
        return this.digest.digest();
    }

    @Override
    public void mark(int readLimit) {
        this.digestLastMarked = this.cloneFrom(this.digest);
    }

    private MessageDigest cloneFrom(MessageDigest from) {
        try {
            return (MessageDigest)from.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("unexpected", e);
        }
    }
}

