/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.core.client.config;

import codegurushadow.software.amazon.awssdk.annotations.Immutable;
import codegurushadow.software.amazon.awssdk.annotations.SdkPublicApi;
import codegurushadow.software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption;
import codegurushadow.software.amazon.awssdk.utils.AttributeMap;
import codegurushadow.software.amazon.awssdk.utils.ExecutorUtils;
import codegurushadow.software.amazon.awssdk.utils.builder.CopyableBuilder;
import codegurushadow.software.amazon.awssdk.utils.builder.ToCopyableBuilder;
import java.util.Map;
import java.util.concurrent.Executor;

@Immutable
@SdkPublicApi
public final class ClientAsyncConfiguration
implements ToCopyableBuilder<Builder, ClientAsyncConfiguration> {
    private final AttributeMap advancedOptions;

    private ClientAsyncConfiguration(DefaultBuilder builder) {
        this.advancedOptions = builder.advancedOptions.build();
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    @Override
    public Builder toBuilder() {
        return new DefaultBuilder().advancedOptions(this.advancedOptions);
    }

    public <T> T advancedOption(SdkAdvancedAsyncClientOption<T> option) {
        return this.advancedOptions.get(option);
    }

    private static class DefaultBuilder
    implements Builder {
        private AttributeMap.Builder advancedOptions = AttributeMap.builder();

        private DefaultBuilder() {
        }

        @Override
        public <T> Builder advancedOption(SdkAdvancedAsyncClientOption<T> option, T value) {
            if (option == SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR) {
                Executor executor = (Executor)SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR.convertValue(value);
                this.advancedOptions.put(SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR, ExecutorUtils.unmanagedExecutor(executor));
            } else {
                this.advancedOptions.put(option, value);
            }
            return this;
        }

        @Override
        public Builder advancedOptions(Map<SdkAdvancedAsyncClientOption<?>, ?> advancedOptions) {
            this.advancedOptions.putAll(advancedOptions);
            return this;
        }

        public void setAdvancedOptions(Map<SdkAdvancedAsyncClientOption<?>, Object> advancedOptions) {
            this.advancedOptions(advancedOptions);
        }

        @Override
        public ClientAsyncConfiguration build() {
            return new ClientAsyncConfiguration(this);
        }

        Builder advancedOptions(AttributeMap advancedOptions) {
            this.advancedOptions = advancedOptions.toBuilder();
            return this;
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ClientAsyncConfiguration> {
        public <T> Builder advancedOption(SdkAdvancedAsyncClientOption<T> var1, T var2);

        public Builder advancedOptions(Map<SdkAdvancedAsyncClientOption<?>, ?> var1);
    }
}

