/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.core.interceptor;

import codegurushadow.org.reactivestreams.Publisher;
import codegurushadow.software.amazon.awssdk.annotations.SdkPublicApi;
import codegurushadow.software.amazon.awssdk.core.SdkRequest;
import codegurushadow.software.amazon.awssdk.core.SdkResponse;
import codegurushadow.software.amazon.awssdk.core.async.AsyncRequestBody;
import codegurushadow.software.amazon.awssdk.core.interceptor.Context;
import codegurushadow.software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import codegurushadow.software.amazon.awssdk.core.sync.RequestBody;
import codegurushadow.software.amazon.awssdk.http.SdkHttpRequest;
import codegurushadow.software.amazon.awssdk.http.SdkHttpResponse;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Optional;

@SdkPublicApi
public interface ExecutionInterceptor {
    default public void beforeExecution(Context.BeforeExecution context, ExecutionAttributes executionAttributes) {
    }

    default public SdkRequest modifyRequest(Context.ModifyRequest context, ExecutionAttributes executionAttributes) {
        return context.request();
    }

    default public void beforeMarshalling(Context.BeforeMarshalling context, ExecutionAttributes executionAttributes) {
    }

    default public void afterMarshalling(Context.AfterMarshalling context, ExecutionAttributes executionAttributes) {
    }

    default public SdkHttpRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        return context.httpRequest();
    }

    default public Optional<RequestBody> modifyHttpContent(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        return context.requestBody();
    }

    default public Optional<AsyncRequestBody> modifyAsyncHttpContent(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        return context.asyncRequestBody();
    }

    default public void beforeTransmission(Context.BeforeTransmission context, ExecutionAttributes executionAttributes) {
    }

    default public void afterTransmission(Context.AfterTransmission context, ExecutionAttributes executionAttributes) {
    }

    default public SdkHttpResponse modifyHttpResponse(Context.ModifyHttpResponse context, ExecutionAttributes executionAttributes) {
        return context.httpResponse();
    }

    default public Optional<Publisher<ByteBuffer>> modifyAsyncHttpResponseContent(Context.ModifyHttpResponse context, ExecutionAttributes executionAttributes) {
        return context.responsePublisher();
    }

    default public Optional<InputStream> modifyHttpResponseContent(Context.ModifyHttpResponse context, ExecutionAttributes executionAttributes) {
        return context.responseBody();
    }

    default public void beforeUnmarshalling(Context.BeforeUnmarshalling context, ExecutionAttributes executionAttributes) {
    }

    default public void afterUnmarshalling(Context.AfterUnmarshalling context, ExecutionAttributes executionAttributes) {
    }

    default public SdkResponse modifyResponse(Context.ModifyResponse context, ExecutionAttributes executionAttributes) {
        return context.response();
    }

    default public void afterExecution(Context.AfterExecution context, ExecutionAttributes executionAttributes) {
    }

    default public Throwable modifyException(Context.FailedExecution context, ExecutionAttributes executionAttributes) {
        return context.exception();
    }

    default public void onExecutionFailure(Context.FailedExecution context, ExecutionAttributes executionAttributes) {
    }
}

