/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.core.internal.async;

import codegurushadow.software.amazon.awssdk.annotations.SdkInternalApi;
import codegurushadow.software.amazon.awssdk.utils.Validate;
import codegurushadow.software.amazon.awssdk.utils.builder.SdkBuilder;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;

@SdkInternalApi
public final class ChunkBuffer {
    private final AtomicLong remainingBytes;
    private final ByteBuffer currentBuffer;
    private final int bufferSize;

    private ChunkBuffer(Long totalBytes, Integer bufferSize) {
        int chunkSize;
        Validate.notNull(totalBytes, "The totalBytes must not be null", new Object[0]);
        this.bufferSize = chunkSize = bufferSize != null ? bufferSize : 16384;
        this.currentBuffer = ByteBuffer.allocate(chunkSize);
        this.remainingBytes = new AtomicLong(totalBytes);
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    public synchronized Iterable<ByteBuffer> bufferAndCreateChunks(ByteBuffer buffer) {
        int startPosition = 0;
        ArrayList<ByteBuffer> bufferedList = new ArrayList<ByteBuffer>();
        int currentBytesRead = buffer.remaining();
        do {
            int bufferedBytes = this.currentBuffer.position();
            int availableToRead = this.bufferSize - bufferedBytes;
            int bytesToMove = Math.min(availableToRead, currentBytesRead - startPosition);
            if (bufferedBytes == 0) {
                this.currentBuffer.put(buffer.array(), startPosition, bytesToMove);
            } else {
                this.currentBuffer.put(buffer.array(), 0, bytesToMove);
            }
            startPosition += bytesToMove;
            if (this.currentBuffer.position() != this.bufferSize) continue;
            this.currentBuffer.position(0);
            ByteBuffer bufferToSend = ByteBuffer.allocate(this.bufferSize);
            bufferToSend.put(this.currentBuffer.array(), 0, this.bufferSize);
            bufferToSend.clear();
            this.currentBuffer.clear();
            bufferedList.add(bufferToSend);
            this.remainingBytes.addAndGet(-this.bufferSize);
        } while (startPosition < currentBytesRead);
        int remainingBytesInBuffer = this.currentBuffer.position();
        if (this.remainingBytes.get() == (long)remainingBytesInBuffer && (buffer.remaining() == 0 || remainingBytesInBuffer > 0)) {
            this.currentBuffer.clear();
            ByteBuffer trimmedBuffer = ByteBuffer.allocate(remainingBytesInBuffer);
            trimmedBuffer.put(this.currentBuffer.array(), 0, remainingBytesInBuffer);
            trimmedBuffer.clear();
            bufferedList.add(trimmedBuffer);
            this.remainingBytes.addAndGet(-remainingBytesInBuffer);
        }
        return bufferedList;
    }

    private static final class DefaultBuilder
    implements Builder {
        private Integer bufferSize;
        private Long totalBytes;

        private DefaultBuilder() {
        }

        @Override
        public ChunkBuffer build() {
            return new ChunkBuffer(this.totalBytes, this.bufferSize);
        }

        @Override
        public Builder bufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        @Override
        public Builder totalBytes(long totalBytes) {
            this.totalBytes = totalBytes;
            return this;
        }
    }

    public static interface Builder
    extends SdkBuilder<Builder, ChunkBuffer> {
        public Builder bufferSize(int var1);

        public Builder totalBytes(long var1);
    }
}

