/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.core.internal.http;

import codegurushadow.software.amazon.awssdk.annotations.SdkInternalApi;
import codegurushadow.software.amazon.awssdk.annotations.ThreadSafe;
import codegurushadow.software.amazon.awssdk.core.Response;
import codegurushadow.software.amazon.awssdk.core.SdkRequest;
import codegurushadow.software.amazon.awssdk.core.async.AsyncRequestBody;
import codegurushadow.software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import codegurushadow.software.amazon.awssdk.core.exception.SdkClientException;
import codegurushadow.software.amazon.awssdk.core.http.ExecutionContext;
import codegurushadow.software.amazon.awssdk.core.internal.http.HttpClientDependencies;
import codegurushadow.software.amazon.awssdk.core.internal.http.RequestExecutionContext;
import codegurushadow.software.amazon.awssdk.core.internal.http.TransformingAsyncResponseHandler;
import codegurushadow.software.amazon.awssdk.core.internal.http.pipeline.RequestPipelineBuilder;
import codegurushadow.software.amazon.awssdk.core.internal.http.pipeline.stages.AfterExecutionInterceptorsStage;
import codegurushadow.software.amazon.awssdk.core.internal.http.pipeline.stages.ApplyTransactionIdStage;
import codegurushadow.software.amazon.awssdk.core.internal.http.pipeline.stages.ApplyUserAgentStage;
import codegurushadow.software.amazon.awssdk.core.internal.http.pipeline.stages.AsyncApiCallAttemptMetricCollectionStage;
import codegurushadow.software.amazon.awssdk.core.internal.http.pipeline.stages.AsyncApiCallMetricCollectionStage;
import codegurushadow.software.amazon.awssdk.core.internal.http.pipeline.stages.AsyncApiCallTimeoutTrackingStage;
import codegurushadow.software.amazon.awssdk.core.internal.http.pipeline.stages.AsyncBeforeTransmissionExecutionInterceptorsStage;
import codegurushadow.software.amazon.awssdk.core.internal.http.pipeline.stages.AsyncExecutionFailureExceptionReportingStage;
import codegurushadow.software.amazon.awssdk.core.internal.http.pipeline.stages.AsyncRetryableStage;
import codegurushadow.software.amazon.awssdk.core.internal.http.pipeline.stages.AsyncSigningStage;
import codegurushadow.software.amazon.awssdk.core.internal.http.pipeline.stages.MakeAsyncHttpRequestStage;
import codegurushadow.software.amazon.awssdk.core.internal.http.pipeline.stages.MakeRequestImmutableStage;
import codegurushadow.software.amazon.awssdk.core.internal.http.pipeline.stages.MakeRequestMutableStage;
import codegurushadow.software.amazon.awssdk.core.internal.http.pipeline.stages.MergeCustomHeadersStage;
import codegurushadow.software.amazon.awssdk.core.internal.http.pipeline.stages.MergeCustomQueryParamsStage;
import codegurushadow.software.amazon.awssdk.core.internal.http.pipeline.stages.UnwrapResponseContainer;
import codegurushadow.software.amazon.awssdk.core.internal.util.ThrowableUtils;
import codegurushadow.software.amazon.awssdk.http.SdkHttpFullRequest;
import codegurushadow.software.amazon.awssdk.utils.SdkAutoCloseable;
import java.util.concurrent.CompletableFuture;

@ThreadSafe
@SdkInternalApi
public final class AmazonAsyncHttpClient
implements SdkAutoCloseable {
    private final HttpClientDependencies httpClientDependencies;

    public AmazonAsyncHttpClient(SdkClientConfiguration clientConfiguration) {
        this.httpClientDependencies = HttpClientDependencies.builder().clientConfiguration(clientConfiguration).build();
    }

    @Override
    public void close() {
        this.httpClientDependencies.close();
    }

    public RequestExecutionBuilder requestExecutionBuilder() {
        return new RequestExecutionBuilderImpl();
    }

    private class RequestExecutionBuilderImpl
    implements RequestExecutionBuilder {
        private AsyncRequestBody requestProvider;
        private SdkHttpFullRequest request;
        private SdkRequest originalRequest;
        private ExecutionContext executionContext;

        private RequestExecutionBuilderImpl() {
        }

        @Override
        public RequestExecutionBuilder requestProvider(AsyncRequestBody requestProvider) {
            this.requestProvider = requestProvider;
            return this;
        }

        @Override
        public RequestExecutionBuilder request(SdkHttpFullRequest request) {
            this.request = request;
            return this;
        }

        @Override
        public RequestExecutionBuilder executionContext(ExecutionContext executionContext) {
            this.executionContext = executionContext;
            return this;
        }

        @Override
        public RequestExecutionBuilder originalRequest(SdkRequest originalRequest) {
            this.originalRequest = originalRequest;
            return this;
        }

        @Override
        public <OutputT> CompletableFuture<OutputT> execute(TransformingAsyncResponseHandler<Response<OutputT>> responseHandler) {
            try {
                return (CompletableFuture)RequestPipelineBuilder.first(RequestPipelineBuilder.first(MakeRequestMutableStage::new).then(ApplyTransactionIdStage::new).then(ApplyUserAgentStage::new).then(MergeCustomHeadersStage::new).then(MergeCustomQueryParamsStage::new).then(MakeRequestImmutableStage::new).then(RequestPipelineBuilder.first(AsyncSigningStage::new).then(AsyncBeforeTransmissionExecutionInterceptorsStage::new).then(d -> new MakeAsyncHttpRequestStage(responseHandler, (HttpClientDependencies)d)).wrappedWith(AsyncApiCallAttemptMetricCollectionStage::new).wrappedWith((deps, wrapped) -> new AsyncRetryableStage(responseHandler, (HttpClientDependencies)deps, wrapped)).then(RequestPipelineBuilder.async(() -> new UnwrapResponseContainer())).then(RequestPipelineBuilder.async(() -> new AfterExecutionInterceptorsStage())).wrappedWith(AsyncExecutionFailureExceptionReportingStage::new).wrappedWith(AsyncApiCallTimeoutTrackingStage::new).wrappedWith(AsyncApiCallMetricCollectionStage::new)::build)::build).build(AmazonAsyncHttpClient.this.httpClientDependencies).execute(this.request, this.createRequestExecutionDependencies());
            }
            catch (RuntimeException e) {
                throw ThrowableUtils.asSdkException(e);
            }
            catch (Exception e) {
                throw SdkClientException.builder().cause(e).build();
            }
        }

        private RequestExecutionContext createRequestExecutionDependencies() {
            return RequestExecutionContext.builder().requestProvider(this.requestProvider).originalRequest(this.originalRequest).executionContext(this.executionContext).build();
        }
    }

    public static interface RequestExecutionBuilder {
        public RequestExecutionBuilder requestProvider(AsyncRequestBody var1);

        public RequestExecutionBuilder request(SdkHttpFullRequest var1);

        public RequestExecutionBuilder executionContext(ExecutionContext var1);

        public RequestExecutionBuilder originalRequest(SdkRequest var1);

        public <OutputT> CompletableFuture<OutputT> execute(TransformingAsyncResponseHandler<Response<OutputT>> var1);
    }
}

