/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.core.internal.http;

import codegurushadow.software.amazon.awssdk.annotations.SdkInternalApi;
import codegurushadow.software.amazon.awssdk.annotations.ThreadSafe;
import codegurushadow.software.amazon.awssdk.core.Response;
import codegurushadow.software.amazon.awssdk.core.SdkRequest;
import codegurushadow.software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import codegurushadow.software.amazon.awssdk.core.exception.SdkClientException;
import codegurushadow.software.amazon.awssdk.core.http.ExecutionContext;
import codegurushadow.software.amazon.awssdk.core.http.HttpResponseHandler;
import codegurushadow.software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import codegurushadow.software.amazon.awssdk.core.interceptor.InterceptorContext;
import codegurushadow.software.amazon.awssdk.core.internal.http.HttpClientDependencies;
import codegurushadow.software.amazon.awssdk.core.internal.http.RequestExecutionContext;
import codegurushadow.software.amazon.awssdk.core.internal.http.StreamManagingStage;
import codegurushadow.software.amazon.awssdk.core.internal.http.pipeline.RequestPipelineBuilder;
import codegurushadow.software.amazon.awssdk.core.internal.http.pipeline.stages.AfterExecutionInterceptorsStage;
import codegurushadow.software.amazon.awssdk.core.internal.http.pipeline.stages.AfterTransmissionExecutionInterceptorsStage;
import codegurushadow.software.amazon.awssdk.core.internal.http.pipeline.stages.ApiCallAttemptMetricCollectionStage;
import codegurushadow.software.amazon.awssdk.core.internal.http.pipeline.stages.ApiCallAttemptTimeoutTrackingStage;
import codegurushadow.software.amazon.awssdk.core.internal.http.pipeline.stages.ApiCallMetricCollectionStage;
import codegurushadow.software.amazon.awssdk.core.internal.http.pipeline.stages.ApiCallTimeoutTrackingStage;
import codegurushadow.software.amazon.awssdk.core.internal.http.pipeline.stages.ApplyTransactionIdStage;
import codegurushadow.software.amazon.awssdk.core.internal.http.pipeline.stages.ApplyUserAgentStage;
import codegurushadow.software.amazon.awssdk.core.internal.http.pipeline.stages.BeforeTransmissionExecutionInterceptorsStage;
import codegurushadow.software.amazon.awssdk.core.internal.http.pipeline.stages.BeforeUnmarshallingExecutionInterceptorsStage;
import codegurushadow.software.amazon.awssdk.core.internal.http.pipeline.stages.ExecutionFailureExceptionReportingStage;
import codegurushadow.software.amazon.awssdk.core.internal.http.pipeline.stages.HandleResponseStage;
import codegurushadow.software.amazon.awssdk.core.internal.http.pipeline.stages.MakeHttpRequestStage;
import codegurushadow.software.amazon.awssdk.core.internal.http.pipeline.stages.MakeRequestImmutableStage;
import codegurushadow.software.amazon.awssdk.core.internal.http.pipeline.stages.MakeRequestMutableStage;
import codegurushadow.software.amazon.awssdk.core.internal.http.pipeline.stages.MergeCustomHeadersStage;
import codegurushadow.software.amazon.awssdk.core.internal.http.pipeline.stages.MergeCustomQueryParamsStage;
import codegurushadow.software.amazon.awssdk.core.internal.http.pipeline.stages.RetryableStage;
import codegurushadow.software.amazon.awssdk.core.internal.http.pipeline.stages.SigningStage;
import codegurushadow.software.amazon.awssdk.core.internal.http.pipeline.stages.TimeoutExceptionHandlingStage;
import codegurushadow.software.amazon.awssdk.core.internal.http.pipeline.stages.UnwrapResponseContainer;
import codegurushadow.software.amazon.awssdk.http.SdkHttpFullRequest;
import codegurushadow.software.amazon.awssdk.http.SdkHttpFullResponse;
import codegurushadow.software.amazon.awssdk.utils.SdkAutoCloseable;

@ThreadSafe
@SdkInternalApi
public final class AmazonSyncHttpClient
implements SdkAutoCloseable {
    private final HttpClientDependencies httpClientDependencies;

    public AmazonSyncHttpClient(SdkClientConfiguration clientConfiguration) {
        this.httpClientDependencies = HttpClientDependencies.builder().clientConfiguration(clientConfiguration).build();
    }

    @Override
    public void close() {
        this.httpClientDependencies.close();
    }

    public RequestExecutionBuilder requestExecutionBuilder() {
        return new RequestExecutionBuilderImpl();
    }

    private class RequestExecutionBuilderImpl
    implements RequestExecutionBuilder {
        private SdkHttpFullRequest request;
        private SdkRequest originalRequest;
        private ExecutionContext executionContext;

        private RequestExecutionBuilderImpl() {
        }

        @Override
        public RequestExecutionBuilder request(SdkHttpFullRequest request) {
            this.request = request;
            return this;
        }

        @Override
        public RequestExecutionBuilder originalRequest(SdkRequest originalRequest) {
            this.originalRequest = originalRequest;
            return this;
        }

        @Override
        public RequestExecutionBuilder executionContext(ExecutionContext executionContext) {
            this.executionContext = executionContext;
            return this;
        }

        @Override
        public <OutputT> OutputT execute(HttpResponseHandler<Response<OutputT>> responseHandler) {
            if (this.request != null && this.executionContext != null) {
                this.executionContext.interceptorContext((InterceptorContext)this.executionContext.interceptorContext().copy(ib -> ib.httpRequest(this.request)));
            }
            try {
                return (OutputT)RequestPipelineBuilder.first(RequestPipelineBuilder.first(MakeRequestMutableStage::new).then(ApplyTransactionIdStage::new).then(ApplyUserAgentStage::new).then(MergeCustomHeadersStage::new).then(MergeCustomQueryParamsStage::new).then(MakeRequestImmutableStage::new).then(RequestPipelineBuilder.first(SigningStage::new).then(BeforeTransmissionExecutionInterceptorsStage::new).then(MakeHttpRequestStage::new).then(AfterTransmissionExecutionInterceptorsStage::new).then(BeforeUnmarshallingExecutionInterceptorsStage::new).then(() -> new HandleResponseStage(responseHandler)).wrappedWith(ApiCallAttemptTimeoutTrackingStage::new).wrappedWith(TimeoutExceptionHandlingStage::new).wrappedWith((deps, wrapped) -> new ApiCallAttemptMetricCollectionStage(wrapped)).wrappedWith(RetryableStage::new)::build).wrappedWith(StreamManagingStage::new).wrappedWith(ApiCallTimeoutTrackingStage::new)::build).wrappedWith((deps, wrapped) -> new ApiCallMetricCollectionStage(wrapped)).then(() -> new UnwrapResponseContainer()).then(() -> new AfterExecutionInterceptorsStage()).wrappedWith(ExecutionFailureExceptionReportingStage::new).build(AmazonSyncHttpClient.this.httpClientDependencies).execute(this.request, this.createRequestExecutionDependencies());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw SdkClientException.builder().cause(e).build();
            }
        }

        private RequestExecutionContext createRequestExecutionDependencies() {
            return RequestExecutionContext.builder().originalRequest(this.originalRequest).executionContext(this.executionContext).build();
        }
    }

    private static class NoOpResponseHandler<T>
    implements HttpResponseHandler<T> {
        private NoOpResponseHandler() {
        }

        @Override
        public T handle(SdkHttpFullResponse response, ExecutionAttributes executionAttributes) {
            return null;
        }

        @Override
        public boolean needsConnectionLeftOpen() {
            return false;
        }
    }

    public static interface RequestExecutionBuilder {
        public RequestExecutionBuilder request(SdkHttpFullRequest var1);

        public RequestExecutionBuilder originalRequest(SdkRequest var1);

        public RequestExecutionBuilder executionContext(ExecutionContext var1);

        public <OutputT> OutputT execute(HttpResponseHandler<Response<OutputT>> var1);
    }
}

