/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.core.internal.http;

import codegurushadow.software.amazon.awssdk.annotations.SdkInternalApi;
import codegurushadow.software.amazon.awssdk.core.Response;
import codegurushadow.software.amazon.awssdk.core.internal.http.InterruptMonitor;
import codegurushadow.software.amazon.awssdk.core.internal.http.RequestExecutionContext;
import codegurushadow.software.amazon.awssdk.core.internal.http.pipeline.RequestPipeline;
import codegurushadow.software.amazon.awssdk.core.io.ReleasableInputStream;
import codegurushadow.software.amazon.awssdk.http.ContentStreamProvider;
import codegurushadow.software.amazon.awssdk.http.SdkHttpFullRequest;
import codegurushadow.software.amazon.awssdk.utils.FunctionalUtils;
import codegurushadow.software.amazon.awssdk.utils.Logger;
import java.io.InputStream;

@SdkInternalApi
public final class StreamManagingStage<OutputT>
implements RequestPipeline<SdkHttpFullRequest, Response<OutputT>> {
    private static final Logger log = Logger.loggerFor(StreamManagingStage.class);
    private final RequestPipeline<SdkHttpFullRequest, Response<OutputT>> wrapped;

    public StreamManagingStage(RequestPipeline<SdkHttpFullRequest, Response<OutputT>> wrapped) {
        this.wrapped = wrapped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response<OutputT> execute(SdkHttpFullRequest request, RequestExecutionContext context) throws Exception {
        ClosingStreamProvider toBeClosed = null;
        if (request.contentStreamProvider().isPresent()) {
            toBeClosed = StreamManagingStage.createManagedProvider(request.contentStreamProvider().get());
            request = request.toBuilder().contentStreamProvider(toBeClosed).build();
        }
        try {
            InterruptMonitor.checkInterrupted();
            Response<OutputT> response = this.wrapped.execute(request, context);
            return response;
        }
        finally {
            if (toBeClosed != null) {
                toBeClosed.closeCurrentStream();
            }
        }
    }

    private static ClosingStreamProvider createManagedProvider(ContentStreamProvider contentStreamProvider) {
        return new ClosingStreamProvider(contentStreamProvider);
    }

    private static class ClosingStreamProvider
    implements ContentStreamProvider {
        private final ContentStreamProvider wrapped;
        private InputStream currentStream;

        ClosingStreamProvider(ContentStreamProvider wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public InputStream newStream() {
            this.currentStream = this.wrapped.newStream();
            return ReleasableInputStream.wrap(this.currentStream).disableClose();
        }

        void closeCurrentStream() {
            if (this.currentStream != null) {
                FunctionalUtils.invokeSafely(this.currentStream::close);
                this.currentStream = null;
            }
        }
    }
}

