/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.core.internal.http.loader;

import codegurushadow.software.amazon.awssdk.annotations.SdkInternalApi;
import codegurushadow.software.amazon.awssdk.core.internal.http.loader.SdkHttpServiceProvider;
import codegurushadow.software.amazon.awssdk.utils.Validate;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@SdkInternalApi
final class SdkHttpServiceProviderChain<T>
implements SdkHttpServiceProvider<T> {
    private final List<SdkHttpServiceProvider<T>> httpProviders;

    @SafeVarargs
    SdkHttpServiceProviderChain(SdkHttpServiceProvider<T> ... httpProviders) {
        this.httpProviders = Arrays.asList(Validate.notEmpty(httpProviders, "httpProviders cannot be null or empty", new Object[0]));
    }

    @Override
    public Optional<T> loadService() {
        return this.httpProviders.stream().map(SdkHttpServiceProvider::loadService).filter(Optional::isPresent).map(Optional::get).findFirst();
    }
}

