/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.core.internal.http.pipeline.stages;

import codegurushadow.software.amazon.awssdk.annotations.SdkInternalApi;
import codegurushadow.software.amazon.awssdk.core.internal.http.RequestExecutionContext;
import codegurushadow.software.amazon.awssdk.core.internal.http.pipeline.RequestPipeline;
import codegurushadow.software.amazon.awssdk.core.metrics.CoreMetric;
import codegurushadow.software.amazon.awssdk.http.SdkHttpFullRequest;
import codegurushadow.software.amazon.awssdk.metrics.MetricCollector;
import codegurushadow.software.amazon.awssdk.utils.CompletableFutureUtils;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;

@SdkInternalApi
public final class AsyncApiCallMetricCollectionStage<OutputT>
implements RequestPipeline<SdkHttpFullRequest, CompletableFuture<OutputT>> {
    private final RequestPipeline<SdkHttpFullRequest, CompletableFuture<OutputT>> wrapped;

    public AsyncApiCallMetricCollectionStage(RequestPipeline<SdkHttpFullRequest, CompletableFuture<OutputT>> wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public CompletableFuture<OutputT> execute(SdkHttpFullRequest input, RequestExecutionContext context) throws Exception {
        MetricCollector metricCollector = context.executionContext().metricCollector();
        CompletableFuture future = new CompletableFuture();
        long callStart = System.nanoTime();
        CompletableFuture<OutputT> executeFuture = this.wrapped.execute(input, context);
        executeFuture.whenComplete((r, t) -> {
            long duration = System.nanoTime() - callStart;
            metricCollector.reportMetric(CoreMetric.API_CALL_DURATION, Duration.ofNanos(duration));
            if (t != null) {
                future.completeExceptionally((Throwable)t);
            } else {
                future.complete(r);
            }
        });
        return CompletableFutureUtils.forwardExceptionTo(future, executeFuture);
    }
}

