/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.core.internal.http.pipeline.stages;

import codegurushadow.software.amazon.awssdk.annotations.SdkInternalApi;
import codegurushadow.software.amazon.awssdk.core.internal.http.RequestExecutionContext;
import codegurushadow.software.amazon.awssdk.core.internal.http.pipeline.RequestPipeline;
import codegurushadow.software.amazon.awssdk.http.SdkHttpFullRequest;
import codegurushadow.software.amazon.awssdk.utils.CompletableFutureUtils;
import java.util.concurrent.CompletableFuture;

@SdkInternalApi
public class AsyncBeforeTransmissionExecutionInterceptorsStage
implements RequestPipeline<CompletableFuture<SdkHttpFullRequest>, CompletableFuture<SdkHttpFullRequest>> {
    @Override
    public CompletableFuture<SdkHttpFullRequest> execute(CompletableFuture<SdkHttpFullRequest> input, RequestExecutionContext context) throws Exception {
        CompletableFuture future = new CompletableFuture();
        input.whenComplete((r, t) -> {
            if (t != null) {
                return;
            }
            try {
                context.interceptorChain().beforeTransmission(context.executionContext().interceptorContext(), context.executionAttributes());
                future.complete(r);
            }
            catch (Throwable interceptorException) {
                future.completeExceptionally(interceptorException);
            }
        });
        return CompletableFutureUtils.forwardExceptionTo(future, input);
    }
}

