/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.core.internal.http.pipeline.stages;

import codegurushadow.software.amazon.awssdk.annotations.SdkInternalApi;
import codegurushadow.software.amazon.awssdk.core.internal.http.RequestExecutionContext;
import codegurushadow.software.amazon.awssdk.core.internal.http.pipeline.RequestPipeline;
import codegurushadow.software.amazon.awssdk.core.internal.http.pipeline.stages.utils.ExceptionReportingUtils;
import codegurushadow.software.amazon.awssdk.core.internal.util.ThrowableUtils;
import codegurushadow.software.amazon.awssdk.http.SdkHttpFullRequest;
import codegurushadow.software.amazon.awssdk.utils.CompletableFutureUtils;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;

@SdkInternalApi
public final class AsyncExecutionFailureExceptionReportingStage<OutputT>
implements RequestPipeline<SdkHttpFullRequest, CompletableFuture<OutputT>> {
    private final RequestPipeline<SdkHttpFullRequest, CompletableFuture<OutputT>> wrapped;

    public AsyncExecutionFailureExceptionReportingStage(RequestPipeline<SdkHttpFullRequest, CompletableFuture<OutputT>> wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public CompletableFuture<OutputT> execute(SdkHttpFullRequest input, RequestExecutionContext context) throws Exception {
        CompletableFuture<OutputT> wrappedExecute = this.wrapped.execute(input, context);
        CompletionStage executeFuture = wrappedExecute.handle((o, t) -> {
            if (t != null) {
                Throwable toReport = t;
                if (toReport instanceof CompletionException) {
                    toReport = toReport.getCause();
                }
                toReport = ExceptionReportingUtils.reportFailureToInterceptors(context, toReport);
                throw CompletableFutureUtils.errorAsCompletionException(ThrowableUtils.asSdkException(toReport));
            }
            return o;
        });
        return CompletableFutureUtils.forwardExceptionTo(executeFuture, wrappedExecute);
    }
}

