/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.core.internal.http.pipeline.stages;

import codegurushadow.software.amazon.awssdk.annotations.SdkInternalApi;
import codegurushadow.software.amazon.awssdk.core.internal.http.RequestExecutionContext;
import codegurushadow.software.amazon.awssdk.core.internal.http.pipeline.RequestPipeline;
import codegurushadow.software.amazon.awssdk.core.internal.http.pipeline.stages.utils.ExceptionReportingUtils;
import codegurushadow.software.amazon.awssdk.core.internal.util.ThrowableUtils;
import codegurushadow.software.amazon.awssdk.http.SdkHttpFullRequest;

@SdkInternalApi
public final class ExecutionFailureExceptionReportingStage<OutputT>
implements RequestPipeline<SdkHttpFullRequest, OutputT> {
    private final RequestPipeline<SdkHttpFullRequest, OutputT> wrapped;

    public ExecutionFailureExceptionReportingStage(RequestPipeline<SdkHttpFullRequest, OutputT> wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public OutputT execute(SdkHttpFullRequest input, RequestExecutionContext context) throws Exception {
        try {
            return this.wrapped.execute(input, context);
        }
        catch (Exception e) {
            Throwable throwable = ExceptionReportingUtils.reportFailureToInterceptors(context, e);
            throw ThrowableUtils.failure(throwable);
        }
    }
}

