/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.core.internal.http.pipeline.stages;

import codegurushadow.software.amazon.awssdk.annotations.SdkInternalApi;
import codegurushadow.software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import codegurushadow.software.amazon.awssdk.core.client.config.SdkClientOption;
import codegurushadow.software.amazon.awssdk.core.internal.http.HttpClientDependencies;
import codegurushadow.software.amazon.awssdk.core.internal.http.RequestExecutionContext;
import codegurushadow.software.amazon.awssdk.core.internal.http.pipeline.MutableRequestToRequestPipeline;
import codegurushadow.software.amazon.awssdk.http.SdkHttpFullRequest;
import codegurushadow.software.amazon.awssdk.utils.http.SdkHttpUtils;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class MergeCustomHeadersStage
implements MutableRequestToRequestPipeline {
    private final SdkClientConfiguration config;

    public MergeCustomHeadersStage(HttpClientDependencies dependencies) {
        this.config = dependencies.clientConfiguration();
    }

    @Override
    public SdkHttpFullRequest.Builder execute(SdkHttpFullRequest.Builder request, RequestExecutionContext context) throws Exception {
        this.addOverrideHeaders(request, this.config.option(SdkClientOption.ADDITIONAL_HTTP_HEADERS), context.requestConfig().headers());
        return request;
    }

    @SafeVarargs
    private final void addOverrideHeaders(SdkHttpFullRequest.Builder request, Map<String, List<String>> ... overrideHeaders) {
        for (Map<String, List<String>> overrideHeader : overrideHeaders) {
            overrideHeader.forEach((headerName, headerValues) -> {
                if (SdkHttpUtils.isSingleHeader(headerName)) {
                    request.removeHeader((String)headerName);
                }
                headerValues.forEach(v -> request.appendHeader((String)headerName, (String)v));
            });
        }
    }
}

