/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.core.internal.interceptor;

import codegurushadow.software.amazon.awssdk.annotations.SdkInternalApi;
import codegurushadow.software.amazon.awssdk.core.ClientType;
import codegurushadow.software.amazon.awssdk.core.async.AsyncRequestBody;
import codegurushadow.software.amazon.awssdk.core.checksums.ChecksumSpecs;
import codegurushadow.software.amazon.awssdk.core.interceptor.Context;
import codegurushadow.software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import codegurushadow.software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import codegurushadow.software.amazon.awssdk.core.internal.async.ChecksumCalculatingAsyncRequestBody;
import codegurushadow.software.amazon.awssdk.core.internal.io.AwsUnsignedChunkedEncodingInputStream;
import codegurushadow.software.amazon.awssdk.core.internal.util.ChunkContentUtils;
import codegurushadow.software.amazon.awssdk.core.internal.util.HttpChecksumUtils;
import codegurushadow.software.amazon.awssdk.http.SdkHttpRequest;
import java.util.Optional;

@SdkInternalApi
public final class AsyncRequestBodyHttpChecksumTrailerInterceptor
implements ExecutionInterceptor {
    @Override
    public Optional<AsyncRequestBody> modifyAsyncHttpContent(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        ChecksumSpecs checksumSpecs = HttpChecksumUtils.checksumSpecWithRequestAlgorithm(executionAttributes).orElse(null);
        if (checksumSpecs == null || checksumSpecs.headerName() == null || !HttpChecksumUtils.isTrailerBasedChecksumForClientType(executionAttributes, context.httpRequest(), ClientType.ASYNC, checksumSpecs, context.asyncRequestBody().isPresent(), context.requestBody().map(requestBody -> requestBody.contentStreamProvider() != null).orElse(false))) {
            return context.asyncRequestBody();
        }
        return context.asyncRequestBody().isPresent() ? Optional.of(ChecksumCalculatingAsyncRequestBody.builder().asyncRequestBody(context.asyncRequestBody().get()).algorithm(checksumSpecs.algorithm()).trailerHeader(checksumSpecs.headerName()).build()) : context.asyncRequestBody();
    }

    @Override
    public SdkHttpRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        ChecksumSpecs checksumSpecs = HttpChecksumUtils.checksumSpecWithRequestAlgorithm(executionAttributes).orElse(null);
        if (checksumSpecs == null || checksumSpecs.headerName() == null || !HttpChecksumUtils.isTrailerBasedChecksumForClientType(executionAttributes, context.httpRequest(), ClientType.ASYNC, checksumSpecs, context.asyncRequestBody().isPresent(), context.requestBody().map(requestBody -> requestBody.contentStreamProvider() != null).orElse(false))) {
            return context.httpRequest();
        }
        long checksumContentLength = ChunkContentUtils.calculateChecksumContentLength(checksumSpecs.algorithm(), checksumSpecs.headerName());
        long originalContentLength = context.asyncRequestBody().isPresent() ? context.asyncRequestBody().get().contentLength().orElse(0L) : 0L;
        return AsyncRequestBodyHttpChecksumTrailerInterceptor.updateHeadersForTrailerChecksum(context, checksumSpecs, checksumContentLength, originalContentLength);
    }

    private static SdkHttpRequest updateHeadersForTrailerChecksum(Context.ModifyHttpRequest context, ChecksumSpecs checksum, long checksumContentLength, long originalContentLength) {
        long chunkLength = AwsUnsignedChunkedEncodingInputStream.calculateStreamContentLength(originalContentLength, 16384L);
        return (SdkHttpRequest)context.httpRequest().copy(r -> r.putHeader("x-amz-trailer", checksum.headerName()).putHeader("Content-encoding", "aws-chunked").putHeader("x-amz-content-sha256", "STREAMING-UNSIGNED-PAYLOAD-TRAILER").putHeader("x-amz-decoded-content-length", Long.toString(originalContentLength)).putHeader("Content-Length", Long.toString(chunkLength + checksumContentLength)));
    }
}

