/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.core.internal.interceptor;

import codegurushadow.software.amazon.awssdk.annotations.SdkInternalApi;
import codegurushadow.software.amazon.awssdk.core.HttpChecksumConstant;
import codegurushadow.software.amazon.awssdk.core.checksums.Algorithm;
import codegurushadow.software.amazon.awssdk.core.checksums.ChecksumSpecs;
import codegurushadow.software.amazon.awssdk.core.interceptor.Context;
import codegurushadow.software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import codegurushadow.software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import codegurushadow.software.amazon.awssdk.core.internal.util.HttpChecksumResolver;
import codegurushadow.software.amazon.awssdk.core.internal.util.HttpChecksumUtils;
import codegurushadow.software.amazon.awssdk.core.sync.RequestBody;
import codegurushadow.software.amazon.awssdk.http.SdkHttpRequest;
import codegurushadow.software.amazon.awssdk.utils.BinaryUtils;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Optional;

@SdkInternalApi
public class HttpChecksumInHeaderInterceptor
implements ExecutionInterceptor {
    @Override
    public void afterMarshalling(Context.AfterMarshalling context, ExecutionAttributes executionAttributes) {
        ChecksumSpecs headerChecksumSpecs = HttpChecksumUtils.checksumSpecWithRequestAlgorithm(executionAttributes).orElse(null);
        if (this.shouldSkipHttpChecksumInHeader(context, executionAttributes, headerChecksumSpecs)) {
            return;
        }
        Optional<RequestBody> syncContent = context.requestBody();
        syncContent.ifPresent(requestBody -> HttpChecksumInHeaderInterceptor.saveContentChecksum(requestBody, executionAttributes, headerChecksumSpecs.algorithm()));
    }

    @Override
    public SdkHttpRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        ChecksumSpecs checksumSpecs = HttpChecksumResolver.getResolvedChecksumSpecs(executionAttributes);
        if (this.shouldSkipHttpChecksumInHeader(context, executionAttributes, checksumSpecs)) {
            return context.httpRequest();
        }
        String httpChecksumValue = executionAttributes.getAttribute(HttpChecksumConstant.HTTP_CHECKSUM_VALUE);
        if (httpChecksumValue != null) {
            return (SdkHttpRequest)context.httpRequest().copy(r -> r.putHeader(checksumSpecs.headerName(), httpChecksumValue));
        }
        return context.httpRequest();
    }

    private static void saveContentChecksum(RequestBody requestBody, ExecutionAttributes executionAttributes, Algorithm algorithm) {
        try {
            String payloadChecksum = BinaryUtils.toBase64(HttpChecksumUtils.computeChecksum(requestBody.contentStreamProvider().newStream(), algorithm));
            executionAttributes.putAttribute(HttpChecksumConstant.HTTP_CHECKSUM_VALUE, payloadChecksum);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private boolean shouldSkipHttpChecksumInHeader(Context.AfterMarshalling context, ExecutionAttributes executionAttributes, ChecksumSpecs headerChecksumSpecs) {
        return headerChecksumSpecs == null || headerChecksumSpecs.algorithm() == null || HttpChecksumUtils.isHttpChecksumPresent(context.httpRequest(), headerChecksumSpecs) || !HttpChecksumUtils.isUnsignedPayload(executionAttributes.getAttribute(HttpChecksumConstant.SIGNING_METHOD), context.httpRequest().protocol(), context.requestBody().map(requestBody -> requestBody.contentStreamProvider() != null).orElse(false)) || headerChecksumSpecs.isRequestStreaming();
    }
}

