/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.core.internal.interceptor;

import codegurushadow.software.amazon.awssdk.annotations.SdkInternalApi;
import codegurushadow.software.amazon.awssdk.core.ClientType;
import codegurushadow.software.amazon.awssdk.core.checksums.ChecksumSpecs;
import codegurushadow.software.amazon.awssdk.core.checksums.SdkChecksum;
import codegurushadow.software.amazon.awssdk.core.interceptor.Context;
import codegurushadow.software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import codegurushadow.software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import codegurushadow.software.amazon.awssdk.core.internal.io.AwsUnsignedChunkedEncodingInputStream;
import codegurushadow.software.amazon.awssdk.core.internal.util.HttpChecksumResolver;
import codegurushadow.software.amazon.awssdk.core.internal.util.HttpChecksumUtils;
import codegurushadow.software.amazon.awssdk.core.sync.RequestBody;
import codegurushadow.software.amazon.awssdk.http.ContentStreamProvider;
import codegurushadow.software.amazon.awssdk.http.SdkHttpRequest;
import codegurushadow.software.amazon.awssdk.utils.IoUtils;
import java.io.InputStream;
import java.util.Optional;

@SdkInternalApi
public final class SyncHttpChecksumInTrailerInterceptor
implements ExecutionInterceptor {
    @Override
    public Optional<RequestBody> modifyHttpContent(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        ChecksumSpecs checksumSpecs = HttpChecksumUtils.checksumSpecWithRequestAlgorithm(executionAttributes).orElse(null);
        if (!SyncHttpChecksumInTrailerInterceptor.shouldAddTrailerBasedChecksumInRequest(context, executionAttributes, checksumSpecs)) {
            return context.requestBody();
        }
        RequestBody requestBody = context.requestBody().get();
        ChecksumCalculatingStreamProvider streamProvider = new ChecksumCalculatingStreamProvider(requestBody.contentStreamProvider(), checksumSpecs);
        long checksumContentLength = AwsUnsignedChunkedEncodingInputStream.calculateChecksumContentLength(checksumSpecs.algorithm(), checksumSpecs.headerName());
        return Optional.of(RequestBody.fromContentProvider(streamProvider, AwsUnsignedChunkedEncodingInputStream.calculateStreamContentLength(requestBody.optionalContentLength().orElse(0L), 131072L) + checksumContentLength, requestBody.contentType()));
    }

    private static boolean shouldAddTrailerBasedChecksumInRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes, ChecksumSpecs checksumSpecs) {
        return checksumSpecs != null && context.requestBody().isPresent() && HttpChecksumUtils.isTrailerBasedChecksumForClientType(executionAttributes, context.httpRequest(), ClientType.SYNC, checksumSpecs, context.requestBody().isPresent(), context.requestBody().map(requestBody -> requestBody.contentStreamProvider() != null).orElse(false));
    }

    @Override
    public SdkHttpRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        ChecksumSpecs checksumSpecs = HttpChecksumUtils.checksumSpecWithRequestAlgorithm(executionAttributes).orElse(null);
        if (!SyncHttpChecksumInTrailerInterceptor.shouldAddTrailerBasedChecksumInRequest(context, executionAttributes, checksumSpecs)) {
            return context.httpRequest();
        }
        ChecksumSpecs checksum = HttpChecksumResolver.getResolvedChecksumSpecs(executionAttributes);
        long checksumContentLength = AwsUnsignedChunkedEncodingInputStream.calculateChecksumContentLength(checksum.algorithm(), checksum.headerName());
        long originalContentLength = context.requestBody().get().optionalContentLength().orElse(0L);
        return (SdkHttpRequest)context.httpRequest().copy(r -> r.putHeader("x-amz-trailer", checksum.headerName()).putHeader("Content-encoding", "aws-chunked").putHeader("x-amz-content-sha256", "STREAMING-UNSIGNED-PAYLOAD-TRAILER").putHeader("x-amz-decoded-content-length", Long.toString(originalContentLength)).putHeader("Content-Length", Long.toString(AwsUnsignedChunkedEncodingInputStream.calculateStreamContentLength(originalContentLength, 131072L) + checksumContentLength)));
    }

    static final class ChecksumCalculatingStreamProvider
    implements ContentStreamProvider {
        private final ContentStreamProvider underlyingInputStreamProvider;
        private final String checksumHeaderForTrailer;
        private final ChecksumSpecs checksumSpecs;
        private InputStream currentStream;
        private SdkChecksum sdkChecksum;

        ChecksumCalculatingStreamProvider(ContentStreamProvider underlyingInputStreamProvider, ChecksumSpecs checksumSpecs) {
            this.underlyingInputStreamProvider = underlyingInputStreamProvider;
            this.sdkChecksum = SdkChecksum.forAlgorithm(checksumSpecs.algorithm());
            this.checksumHeaderForTrailer = checksumSpecs.headerName();
            this.checksumSpecs = checksumSpecs;
        }

        @Override
        public InputStream newStream() {
            this.closeCurrentStream();
            this.currentStream = ((AwsUnsignedChunkedEncodingInputStream.Builder)((AwsUnsignedChunkedEncodingInputStream.Builder)((AwsUnsignedChunkedEncodingInputStream.Builder)AwsUnsignedChunkedEncodingInputStream.builder().inputStream(this.underlyingInputStreamProvider.newStream())).sdkChecksum(this.sdkChecksum)).checksumHeaderForTrailer(this.checksumHeaderForTrailer)).build();
            return this.currentStream;
        }

        private void closeCurrentStream() {
            this.sdkChecksum = SdkChecksum.forAlgorithm(this.checksumSpecs.algorithm());
            if (this.currentStream != null) {
                IoUtils.closeQuietly(this.currentStream, null);
                this.currentStream = null;
            }
        }
    }
}

