/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.core.internal.io;

import codegurushadow.software.amazon.awssdk.annotations.SdkInternalApi;
import codegurushadow.software.amazon.awssdk.core.checksums.SdkChecksum;
import codegurushadow.software.amazon.awssdk.core.internal.chunked.AwsChunkedEncodingConfig;
import codegurushadow.software.amazon.awssdk.core.internal.io.ChunkContentIterator;
import codegurushadow.software.amazon.awssdk.core.internal.io.DecodedStreamBuffer;
import codegurushadow.software.amazon.awssdk.core.io.SdkInputStream;
import codegurushadow.software.amazon.awssdk.utils.Logger;
import codegurushadow.software.amazon.awssdk.utils.Validate;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

@SdkInternalApi
public abstract class AwsChunkedEncodingInputStream
extends SdkInputStream {
    public static final int DEFAULT_CHUNK_SIZE = 131072;
    protected static final int SKIP_BUFFER_SIZE = 262144;
    protected static final String CRLF = "\r\n";
    protected static final byte[] FINAL_CHUNK = new byte[0];
    protected static final String HEADER_COLON_SEPARATOR = ":";
    private static final Logger log = Logger.loggerFor(AwsChunkedEncodingInputStream.class);
    protected byte[] calculatedChecksum = null;
    protected final String checksumHeaderForTrailer;
    protected boolean isTrailingTerminated = true;
    private InputStream is = null;
    private final int chunkSize;
    private final int maxBufferSize;
    private final SdkChecksum sdkChecksum;
    private boolean isLastTrailingCrlf;
    private ChunkContentIterator currentChunkIterator;
    private DecodedStreamBuffer decodedStreamBuffer;
    private boolean isAtStart = true;
    private boolean isTerminating = false;

    protected AwsChunkedEncodingInputStream(InputStream in, SdkChecksum sdkChecksum, String checksumHeaderForTrailer, AwsChunkedEncodingConfig config) {
        AwsChunkedEncodingConfig awsChunkedEncodingConfig = config == null ? AwsChunkedEncodingConfig.create() : config;
        int providedMaxBufferSize = awsChunkedEncodingConfig.bufferSize();
        if (in instanceof AwsChunkedEncodingInputStream) {
            AwsChunkedEncodingInputStream originalChunkedStream = (AwsChunkedEncodingInputStream)in;
            providedMaxBufferSize = Math.max(originalChunkedStream.maxBufferSize, providedMaxBufferSize);
            this.is = originalChunkedStream.is;
            this.decodedStreamBuffer = originalChunkedStream.decodedStreamBuffer;
        } else {
            this.is = in;
            this.decodedStreamBuffer = null;
        }
        this.chunkSize = awsChunkedEncodingConfig.chunkSize();
        this.maxBufferSize = providedMaxBufferSize;
        if (this.maxBufferSize < this.chunkSize) {
            throw new IllegalArgumentException("Max buffer size should not be less than chunk size");
        }
        this.sdkChecksum = sdkChecksum;
        this.checksumHeaderForTrailer = checksumHeaderForTrailer;
    }

    @Override
    public int read() throws IOException {
        byte[] tmp = new byte[1];
        int count = this.read(tmp, 0, 1);
        if (count > 0) {
            log.debug(() -> "One byte read from the stream.");
            int unsignedByte = tmp[0] & 0xFF;
            return unsignedByte;
        }
        return count;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int count;
        this.abortIfNeeded();
        Validate.notNull(b, "buff", new Object[0]);
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (null == this.currentChunkIterator || !this.currentChunkIterator.hasNext()) {
            if (this.isTerminating && this.isTrailingTerminated) {
                return -1;
            }
            if (!this.isTerminating) {
                this.isTerminating = this.setUpNextChunk();
            } else {
                this.isTrailingTerminated = this.setUpTrailingChunks();
            }
        }
        if ((count = this.currentChunkIterator.read(b, off, len)) > 0) {
            this.isAtStart = false;
            log.trace(() -> count + " byte read from the stream.");
        }
        return count;
    }

    private boolean setUpTrailingChunks() {
        if (this.sdkChecksum == null) {
            return true;
        }
        if (this.calculatedChecksum == null) {
            this.calculatedChecksum = this.sdkChecksum.getChecksumBytes();
            this.currentChunkIterator = new ChunkContentIterator(this.createChecksumChunkHeader());
            return false;
        }
        if (!this.isLastTrailingCrlf) {
            this.currentChunkIterator = new ChunkContentIterator(CRLF.getBytes(StandardCharsets.UTF_8));
            this.isLastTrailingCrlf = true;
        }
        return true;
    }

    @Override
    public long skip(long n) throws IOException {
        long remaining;
        int count;
        if (n <= 0L) {
            return 0L;
        }
        int toskip = (int)Math.min(262144L, n);
        byte[] temp = new byte[toskip];
        for (remaining = n; remaining > 0L && (count = this.read(temp, 0, toskip)) >= 0; remaining -= (long)count) {
        }
        return n - remaining;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readlimit) {
        this.abortIfNeeded();
        if (!this.isAtStart) {
            throw new UnsupportedOperationException("Chunk-encoded stream only supports mark() at the start of the stream.");
        }
        if (this.sdkChecksum != null) {
            this.sdkChecksum.mark(readlimit);
        }
        if (this.is.markSupported()) {
            log.debug(() -> "AwsChunkedEncodingInputStream marked at the start of the stream (will directly mark the wrapped stream since it's mark-supported).");
            this.is.mark(readlimit);
        } else {
            log.debug(() -> "AwsChunkedEncodingInputStream marked at the start of the stream (initializing the buffer since the wrapped stream is not mark-supported).");
            this.decodedStreamBuffer = new DecodedStreamBuffer(this.maxBufferSize);
        }
    }

    @Override
    public void reset() throws IOException {
        this.abortIfNeeded();
        this.currentChunkIterator = null;
        if (this.sdkChecksum != null) {
            this.sdkChecksum.reset();
        }
        if (this.is.markSupported()) {
            log.debug(() -> "AwsChunkedEncodingInputStream reset (will reset the wrapped stream because it is mark-supported).");
            this.is.reset();
        } else {
            log.debug(() -> "AwsChunkedEncodingInputStream reset (will use the buffer of the decoded stream).");
            Validate.notNull(this.decodedStreamBuffer, "Cannot reset the stream because the mark is not set.", new Object[0]);
            this.decodedStreamBuffer.startReadBuffer();
        }
        this.isAtStart = true;
        this.isTerminating = false;
    }

    private boolean setUpNextChunk() throws IOException {
        byte[] chunkData = new byte[this.chunkSize];
        int chunkSizeInBytes = 0;
        while (chunkSizeInBytes < this.chunkSize) {
            if (null != this.decodedStreamBuffer && this.decodedStreamBuffer.hasNext()) {
                chunkData[chunkSizeInBytes++] = this.decodedStreamBuffer.next();
                continue;
            }
            int bytesToRead = this.chunkSize - chunkSizeInBytes;
            int count = this.is.read(chunkData, chunkSizeInBytes, bytesToRead);
            if (count == -1) break;
            if (null != this.decodedStreamBuffer) {
                this.decodedStreamBuffer.buffer(chunkData, chunkSizeInBytes, count);
            }
            chunkSizeInBytes += count;
        }
        if (chunkSizeInBytes == 0) {
            if (this.sdkChecksum != null) {
                this.isTrailingTerminated = false;
            }
            byte[] finalChunk = this.createFinalChunk(FINAL_CHUNK);
            this.currentChunkIterator = new ChunkContentIterator(finalChunk);
            return true;
        }
        if (chunkSizeInBytes < chunkData.length) {
            chunkData = Arrays.copyOf(chunkData, chunkSizeInBytes);
        }
        byte[] chunkContent = this.createChunk(chunkData);
        this.currentChunkIterator = new ChunkContentIterator(chunkContent);
        if (this.sdkChecksum != null) {
            this.sdkChecksum.update(chunkData);
        }
        return false;
    }

    @Override
    protected InputStream getWrappedInputStream() {
        return this.is;
    }

    protected abstract byte[] createFinalChunk(byte[] var1);

    protected abstract byte[] createChunk(byte[] var1);

    protected abstract byte[] createChecksumChunkHeader();

    protected static abstract class Builder<T extends Builder> {
        protected InputStream inputStream;
        protected SdkChecksum sdkChecksum;
        protected String checksumHeaderForTrailer;
        protected AwsChunkedEncodingConfig awsChunkedEncodingConfig;

        protected Builder() {
        }

        public T inputStream(InputStream inputStream) {
            this.inputStream = inputStream;
            return (T)this;
        }

        public T awsChunkedEncodingConfig(AwsChunkedEncodingConfig awsChunkedEncodingConfig) {
            this.awsChunkedEncodingConfig = awsChunkedEncodingConfig;
            return (T)this;
        }

        public T sdkChecksum(SdkChecksum sdkChecksum) {
            this.sdkChecksum = sdkChecksum;
            return (T)this;
        }

        public T checksumHeaderForTrailer(String checksumHeaderForTrailer) {
            this.checksumHeaderForTrailer = checksumHeaderForTrailer;
            return (T)this;
        }
    }
}

