/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.core.internal.util;

import codegurushadow.software.amazon.awssdk.annotations.SdkInternalApi;
import codegurushadow.software.amazon.awssdk.core.checksums.Algorithm;
import codegurushadow.software.amazon.awssdk.core.exception.SdkClientException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

@SdkInternalApi
public final class ChunkContentUtils {
    public static final String HEADER_COLON_SEPARATOR = ":";
    public static final String ZERO_BYTE = "0";
    public static final String CRLF = "\r\n";

    private ChunkContentUtils() {
    }

    public static long calculateChunkLength(long originalContentLength) {
        return (long)(Long.toHexString(originalContentLength).length() + CRLF.length()) + originalContentLength + (long)CRLF.length() + (long)ZERO_BYTE.length() + (long)CRLF.length();
    }

    public static long calculateChecksumContentLength(Algorithm algorithm, String headerName) {
        int checksumLength = algorithm.base64EncodedLength();
        return headerName.length() + HEADER_COLON_SEPARATOR.length() + checksumLength + CRLF.length() + CRLF.length();
    }

    public static ByteBuffer createChecksumTrailer(String computedChecksum, String trailerHeader) {
        StringBuilder headerBuilder = new StringBuilder(trailerHeader).append(HEADER_COLON_SEPARATOR).append(computedChecksum).append(CRLF).append(CRLF);
        return ByteBuffer.wrap(headerBuilder.toString().getBytes(StandardCharsets.UTF_8));
    }

    public static ByteBuffer createChunk(ByteBuffer chunkData, boolean isLastByte) {
        int chunkLength = chunkData.remaining();
        StringBuilder chunkHeader = new StringBuilder(Integer.toHexString(chunkLength));
        chunkHeader.append(CRLF);
        try {
            byte[] header = chunkHeader.toString().getBytes(StandardCharsets.UTF_8);
            byte[] trailer = !isLastByte ? CRLF.getBytes(StandardCharsets.UTF_8) : "".getBytes(StandardCharsets.UTF_8);
            ByteBuffer chunkFormattedBuffer = ByteBuffer.allocate(header.length + chunkLength + trailer.length);
            chunkFormattedBuffer.put(header).put(chunkData).put(trailer);
            chunkFormattedBuffer.flip();
            return chunkFormattedBuffer;
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to create chunked data. " + e.getMessage()).cause(e).build();
        }
    }
}

