/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.core.internal.util;

import codegurushadow.software.amazon.awssdk.annotations.SdkInternalApi;
import codegurushadow.software.amazon.awssdk.core.exception.Crc32MismatchException;
import codegurushadow.software.amazon.awssdk.core.internal.util.Crc32ChecksumCalculatingInputStream;
import codegurushadow.software.amazon.awssdk.core.io.SdkFilterInputStream;
import java.io.IOException;
import java.io.InputStream;

@SdkInternalApi
public class Crc32ChecksumValidatingInputStream
extends SdkFilterInputStream {
    private final long expectedChecksum;

    public Crc32ChecksumValidatingInputStream(InputStream in, long expectedChecksum) {
        super(new Crc32ChecksumCalculatingInputStream(in));
        this.expectedChecksum = expectedChecksum;
    }

    @Override
    public void close() throws IOException {
        try {
            this.validateChecksum();
        }
        finally {
            super.close();
        }
    }

    private void validateChecksum() throws Crc32MismatchException {
        long actualChecksum = ((Crc32ChecksumCalculatingInputStream)this.in).getCrc32Checksum();
        if (this.expectedChecksum != actualChecksum) {
            throw Crc32MismatchException.builder().message(String.format("Expected %d as the Crc32 checksum but the actual calculated checksum was %d", this.expectedChecksum, actualChecksum)).build();
        }
    }
}

