/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.core.internal.util;

import codegurushadow.software.amazon.awssdk.annotations.SdkInternalApi;
import codegurushadow.software.amazon.awssdk.core.checksums.Algorithm;
import codegurushadow.software.amazon.awssdk.core.checksums.ChecksumSpecs;
import codegurushadow.software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import codegurushadow.software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import codegurushadow.software.amazon.awssdk.core.interceptor.trait.HttpChecksum;
import codegurushadow.software.amazon.awssdk.core.internal.util.HttpChecksumUtils;
import codegurushadow.software.amazon.awssdk.utils.StringUtils;
import java.util.List;
import java.util.stream.Collectors;

@SdkInternalApi
public final class HttpChecksumResolver {
    private HttpChecksumResolver() {
    }

    public static ChecksumSpecs getResolvedChecksumSpecs(ExecutionAttributes executionAttributes) {
        HttpChecksum httpChecksumTraitInOperation = executionAttributes.getAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM);
        if (httpChecksumTraitInOperation == null) {
            return null;
        }
        boolean hasRequestValidation = HttpChecksumResolver.hasRequestValidationMode(httpChecksumTraitInOperation);
        String checksumHeaderName = httpChecksumTraitInOperation.requestAlgorithm() != null ? HttpChecksumUtils.httpChecksumHeader(httpChecksumTraitInOperation.requestAlgorithm()) : null;
        List<Algorithm> responseValidationAlgorithms = HttpChecksumResolver.getResponseValidationAlgorithms(httpChecksumTraitInOperation);
        return ChecksumSpecs.builder().algorithm(Algorithm.fromValue(httpChecksumTraitInOperation.requestAlgorithm())).headerName(checksumHeaderName).responseValidationAlgorithms(responseValidationAlgorithms).isValidationEnabled(hasRequestValidation).isRequestChecksumRequired(httpChecksumTraitInOperation.isRequestChecksumRequired()).isRequestStreaming(httpChecksumTraitInOperation.isRequestStreaming()).build();
    }

    private static boolean hasRequestValidationMode(HttpChecksum httpChecksum) {
        return httpChecksum.requestValidationMode() != null;
    }

    private static List<Algorithm> getResponseValidationAlgorithms(HttpChecksum httpChecksumTraitInOperation) {
        List responseValidationAlgorithms = null;
        if (httpChecksumTraitInOperation.responseAlgorithms() != null && !httpChecksumTraitInOperation.responseAlgorithms().isEmpty()) {
            responseValidationAlgorithms = httpChecksumTraitInOperation.responseAlgorithms().stream().filter(StringUtils::isNotBlank).map(StringUtils::trim).map(Algorithm::fromValue).collect(Collectors.toList());
        }
        return responseValidationAlgorithms;
    }
}

