/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.core.internal.waiters;

import codegurushadow.software.amazon.awssdk.annotations.SdkInternalApi;
import codegurushadow.software.amazon.awssdk.annotations.ThreadSafe;
import codegurushadow.software.amazon.awssdk.core.internal.waiters.WaiterConfiguration;
import codegurushadow.software.amazon.awssdk.core.internal.waiters.WaiterExecutor;
import codegurushadow.software.amazon.awssdk.core.waiters.Waiter;
import codegurushadow.software.amazon.awssdk.core.waiters.WaiterAcceptor;
import codegurushadow.software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import codegurushadow.software.amazon.awssdk.core.waiters.WaiterResponse;
import codegurushadow.software.amazon.awssdk.utils.Validate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;

@SdkInternalApi
@ThreadSafe
public final class DefaultWaiter<T>
implements Waiter<T> {
    private final WaiterConfiguration waiterConfiguration;
    private final List<WaiterAcceptor<? super T>> waiterAcceptors;
    private final WaiterExecutor<T> waiterExecutor;

    private DefaultWaiter(DefaultBuilder<T> builder) {
        this.waiterConfiguration = new WaiterConfiguration(((DefaultBuilder)builder).overrideConfiguration);
        this.waiterAcceptors = Collections.unmodifiableList(((DefaultBuilder)builder).waiterAcceptors);
        this.waiterExecutor = new WaiterExecutor<T>(this.waiterConfiguration, this.waiterAcceptors);
    }

    @Override
    public WaiterResponse<T> run(Supplier<T> pollingFunction) {
        return this.waiterExecutor.execute(pollingFunction);
    }

    @Override
    public WaiterResponse<T> run(Supplier<T> pollingFunction, WaiterOverrideConfiguration overrideConfiguration) {
        Validate.paramNotNull(overrideConfiguration, "overrideConfiguration");
        return new WaiterExecutor<T>(new WaiterConfiguration(overrideConfiguration), this.waiterAcceptors).execute(pollingFunction);
    }

    public static <T> Waiter.Builder<T> builder() {
        return new DefaultBuilder();
    }

    public static final class DefaultBuilder<T>
    implements Waiter.Builder<T> {
        private List<WaiterAcceptor<? super T>> waiterAcceptors = new ArrayList<WaiterAcceptor<? super T>>();
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public Waiter.Builder<T> acceptors(List<WaiterAcceptor<? super T>> waiterAcceptors) {
            this.waiterAcceptors = new ArrayList<WaiterAcceptor<T>>(waiterAcceptors);
            return this;
        }

        @Override
        public Waiter.Builder<T> overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public Waiter.Builder<T> addAcceptor(WaiterAcceptor<? super T> waiterAcceptor) {
            this.waiterAcceptors.add(waiterAcceptor);
            return this;
        }

        @Override
        public Waiter<T> build() {
            return new DefaultWaiter(this);
        }
    }
}

