/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.core.io;

import codegurushadow.org.slf4j.LoggerFactory;
import codegurushadow.software.amazon.awssdk.annotations.SdkProtectedApi;
import codegurushadow.software.amazon.awssdk.core.exception.AbortedException;
import codegurushadow.software.amazon.awssdk.core.internal.io.Releasable;
import codegurushadow.software.amazon.awssdk.utils.IoUtils;
import java.io.IOException;
import java.io.InputStream;

@SdkProtectedApi
public abstract class SdkInputStream
extends InputStream
implements Releasable {
    protected abstract InputStream getWrappedInputStream();

    protected final void abortIfNeeded() {
        if (Thread.currentThread().isInterrupted()) {
            try {
                this.abort();
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).debug("FYI", e);
            }
            throw AbortedException.builder().build();
        }
    }

    protected void abort() throws IOException {
    }

    @Override
    public void release() {
        IoUtils.closeQuietly(this, null);
        InputStream in = this.getWrappedInputStream();
        if (in instanceof Releasable) {
            Releasable r = (Releasable)((Object)in);
            r.release();
        }
    }
}

