/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.core.retry.conditions;

import codegurushadow.software.amazon.awssdk.annotations.SdkPublicApi;
import codegurushadow.software.amazon.awssdk.core.internal.retry.SdkDefaultRetrySetting;
import codegurushadow.software.amazon.awssdk.core.retry.RetryPolicyContext;
import codegurushadow.software.amazon.awssdk.core.retry.conditions.MaxNumberOfRetriesCondition;
import codegurushadow.software.amazon.awssdk.core.retry.conditions.OrRetryCondition;
import codegurushadow.software.amazon.awssdk.core.retry.conditions.RetryOnClockSkewCondition;
import codegurushadow.software.amazon.awssdk.core.retry.conditions.RetryOnExceptionsCondition;
import codegurushadow.software.amazon.awssdk.core.retry.conditions.RetryOnStatusCodeCondition;
import codegurushadow.software.amazon.awssdk.core.retry.conditions.RetryOnThrottlingCondition;

@FunctionalInterface
@SdkPublicApi
public interface RetryCondition {
    public boolean shouldRetry(RetryPolicyContext var1);

    default public void requestWillNotBeRetried(RetryPolicyContext context) {
    }

    default public void requestSucceeded(RetryPolicyContext context) {
    }

    public static RetryCondition defaultRetryCondition() {
        return OrRetryCondition.create(RetryOnStatusCodeCondition.create(SdkDefaultRetrySetting.RETRYABLE_STATUS_CODES), RetryOnExceptionsCondition.create(SdkDefaultRetrySetting.RETRYABLE_EXCEPTIONS), RetryOnClockSkewCondition.create(), RetryOnThrottlingCondition.create());
    }

    public static RetryCondition none() {
        return MaxNumberOfRetriesCondition.create(0);
    }
}

