/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.http.apache.internal.conn;

import codegurushadow.org.apache.http.HttpClientConnection;
import codegurushadow.org.apache.http.conn.ConnectionRequest;
import codegurushadow.org.apache.http.conn.HttpClientConnectionManager;
import codegurushadow.org.apache.http.conn.routing.HttpRoute;
import codegurushadow.org.apache.http.protocol.HttpContext;
import codegurushadow.software.amazon.awssdk.annotations.SdkInternalApi;
import codegurushadow.software.amazon.awssdk.http.apache.internal.conn.ClientConnectionRequestFactory;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@SdkInternalApi
public final class ClientConnectionManagerFactory {
    private ClientConnectionManagerFactory() {
    }

    public static HttpClientConnectionManager wrap(HttpClientConnectionManager orig) {
        if (orig instanceof DelegatingHttpClientConnectionManager) {
            throw new IllegalArgumentException();
        }
        return new InstrumentedHttpClientConnectionManager(orig);
    }

    private static class DelegatingHttpClientConnectionManager
    implements HttpClientConnectionManager {
        private final HttpClientConnectionManager delegate;

        protected DelegatingHttpClientConnectionManager(HttpClientConnectionManager delegate) {
            this.delegate = delegate;
        }

        @Override
        public ConnectionRequest requestConnection(HttpRoute route, Object state) {
            return this.delegate.requestConnection(route, state);
        }

        @Override
        public void releaseConnection(HttpClientConnection conn, Object newState, long validDuration, TimeUnit timeUnit) {
            this.delegate.releaseConnection(conn, newState, validDuration, timeUnit);
        }

        @Override
        public void connect(HttpClientConnection conn, HttpRoute route, int connectTimeout, HttpContext context) throws IOException {
            this.delegate.connect(conn, route, connectTimeout, context);
        }

        @Override
        public void upgrade(HttpClientConnection conn, HttpRoute route, HttpContext context) throws IOException {
            this.delegate.upgrade(conn, route, context);
        }

        @Override
        public void routeComplete(HttpClientConnection conn, HttpRoute route, HttpContext context) throws IOException {
            this.delegate.routeComplete(conn, route, context);
        }

        @Override
        public void closeIdleConnections(long idletime, TimeUnit timeUnit) {
            this.delegate.closeIdleConnections(idletime, timeUnit);
        }

        @Override
        public void closeExpiredConnections() {
            this.delegate.closeExpiredConnections();
        }

        @Override
        public void shutdown() {
            this.delegate.shutdown();
        }
    }

    private static class InstrumentedHttpClientConnectionManager
    extends DelegatingHttpClientConnectionManager {
        private InstrumentedHttpClientConnectionManager(HttpClientConnectionManager delegate) {
            super(delegate);
        }

        @Override
        public ConnectionRequest requestConnection(HttpRoute route, Object state) {
            ConnectionRequest connectionRequest = super.requestConnection(route, state);
            return ClientConnectionRequestFactory.wrap(connectionRequest);
        }
    }
}

