/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.http.apache.internal.conn;

import codegurushadow.org.apache.http.HttpResponse;
import codegurushadow.org.apache.http.conn.ConnectionKeepAliveStrategy;
import codegurushadow.org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import codegurushadow.org.apache.http.protocol.HttpContext;
import codegurushadow.software.amazon.awssdk.annotations.SdkInternalApi;

@SdkInternalApi
public class SdkConnectionKeepAliveStrategy
implements ConnectionKeepAliveStrategy {
    private final long maxIdleTime;

    public SdkConnectionKeepAliveStrategy(long maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    @Override
    public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
        long duration = DefaultConnectionKeepAliveStrategy.INSTANCE.getKeepAliveDuration(response, context);
        if (0L < duration && duration < this.maxIdleTime) {
            return duration;
        }
        return this.maxIdleTime;
    }
}

