/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.http.apache.internal.impl;

import codegurushadow.org.apache.http.HttpEntity;
import codegurushadow.org.apache.http.client.config.RequestConfig;
import codegurushadow.org.apache.http.client.methods.HttpDelete;
import codegurushadow.org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import codegurushadow.org.apache.http.client.methods.HttpGet;
import codegurushadow.org.apache.http.client.methods.HttpHead;
import codegurushadow.org.apache.http.client.methods.HttpOptions;
import codegurushadow.org.apache.http.client.methods.HttpPatch;
import codegurushadow.org.apache.http.client.methods.HttpPost;
import codegurushadow.org.apache.http.client.methods.HttpPut;
import codegurushadow.org.apache.http.client.methods.HttpRequestBase;
import codegurushadow.software.amazon.awssdk.annotations.SdkInternalApi;
import codegurushadow.software.amazon.awssdk.http.HttpExecuteRequest;
import codegurushadow.software.amazon.awssdk.http.SdkHttpMethod;
import codegurushadow.software.amazon.awssdk.http.SdkHttpRequest;
import codegurushadow.software.amazon.awssdk.http.apache.internal.ApacheHttpRequestConfig;
import codegurushadow.software.amazon.awssdk.http.apache.internal.RepeatableInputStreamRequestEntity;
import codegurushadow.software.amazon.awssdk.http.apache.internal.utils.ApacheUtils;
import codegurushadow.software.amazon.awssdk.utils.NumericUtils;
import codegurushadow.software.amazon.awssdk.utils.StringUtils;
import codegurushadow.software.amazon.awssdk.utils.http.SdkHttpUtils;
import java.net.URI;
import java.util.Arrays;
import java.util.List;

@SdkInternalApi
public class ApacheHttpRequestFactory {
    private static final List<String> IGNORE_HEADERS = Arrays.asList("Content-Length", "Host");

    public HttpRequestBase create(HttpExecuteRequest request, ApacheHttpRequestConfig requestConfig) {
        HttpRequestBase base = this.createApacheRequest(request, this.sanitizeUri(request.httpRequest()));
        this.addHeadersToRequest(base, request.httpRequest());
        this.addRequestConfig(base, request.httpRequest(), requestConfig);
        return base;
    }

    private URI sanitizeUri(SdkHttpRequest request) {
        String path = request.encodedPath();
        if (path.contains("//")) {
            int port = request.port();
            String protocol = request.protocol();
            String newPath = StringUtils.replace(path, "//", "/%2F");
            String encodedQueryString = request.encodedQueryParameters().map(value -> "?" + value).orElse("");
            String portString = SdkHttpUtils.isUsingStandardPort(protocol, port) ? "" : ":" + port;
            return URI.create(protocol + "://" + request.host() + portString + newPath + encodedQueryString);
        }
        return request.getUri();
    }

    private void addRequestConfig(HttpRequestBase base, SdkHttpRequest request, ApacheHttpRequestConfig requestConfig) {
        int connectTimeout = NumericUtils.saturatedCast(requestConfig.connectionTimeout().toMillis());
        int connectAcquireTimeout = NumericUtils.saturatedCast(requestConfig.connectionAcquireTimeout().toMillis());
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom().setConnectionRequestTimeout(connectAcquireTimeout).setConnectTimeout(connectTimeout).setSocketTimeout(NumericUtils.saturatedCast(requestConfig.socketTimeout().toMillis())).setLocalAddress(requestConfig.localAddress());
        ApacheUtils.disableNormalizeUri(requestConfigBuilder);
        if (SdkHttpMethod.PUT == request.method() && requestConfig.expectContinueEnabled()) {
            requestConfigBuilder.setExpectContinueEnabled(true);
        }
        base.setConfig(requestConfigBuilder.build());
    }

    private HttpRequestBase createApacheRequest(HttpExecuteRequest request, URI uri) {
        switch (request.httpRequest().method()) {
            case HEAD: {
                return new HttpHead(uri);
            }
            case GET: {
                return new HttpGet(uri);
            }
            case DELETE: {
                return new HttpDelete(uri);
            }
            case OPTIONS: {
                return new HttpOptions(uri);
            }
            case PATCH: {
                return this.wrapEntity(request, new HttpPatch(uri));
            }
            case POST: {
                return this.wrapEntity(request, new HttpPost(uri));
            }
            case PUT: {
                return this.wrapEntity(request, new HttpPut(uri));
            }
        }
        throw new RuntimeException("Unknown HTTP method name: " + (Object)((Object)request.httpRequest().method()));
    }

    private HttpRequestBase wrapEntity(HttpExecuteRequest request, HttpEntityEnclosingRequestBase entityEnclosingRequest) {
        if (request.contentStreamProvider().isPresent()) {
            HttpEntity entity = new RepeatableInputStreamRequestEntity(request);
            if (!request.httpRequest().firstMatchingHeader("Content-Length").isPresent()) {
                entity = ApacheUtils.newBufferedHttpEntity(entity);
            }
            entityEnclosingRequest.setEntity(entity);
        }
        return entityEnclosingRequest;
    }

    private void addHeadersToRequest(HttpRequestBase httpRequest, SdkHttpRequest request) {
        httpRequest.addHeader("Host", this.getHostHeaderValue(request));
        request.forEachHeader((name, value) -> {
            if (!IGNORE_HEADERS.contains(name)) {
                for (String headerValue : value) {
                    httpRequest.addHeader((String)name, headerValue);
                }
            }
        });
    }

    private String getHostHeaderValue(SdkHttpRequest request) {
        return !SdkHttpUtils.isUsingStandardPort(request.protocol(), request.port()) ? request.host() + ":" + request.port() : request.host();
    }
}

