/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.http.nio.netty.internal;

import codegurushadow.io.netty.bootstrap.Bootstrap;
import codegurushadow.io.netty.channel.ChannelOption;
import codegurushadow.software.amazon.awssdk.annotations.SdkInternalApi;
import codegurushadow.software.amazon.awssdk.http.nio.netty.SdkEventLoopGroup;
import codegurushadow.software.amazon.awssdk.http.nio.netty.internal.NettyConfiguration;
import codegurushadow.software.amazon.awssdk.http.nio.netty.internal.SdkChannelOptions;
import java.net.InetSocketAddress;

@SdkInternalApi
public class BootstrapProvider {
    private final SdkEventLoopGroup sdkEventLoopGroup;
    private final NettyConfiguration nettyConfiguration;
    private final SdkChannelOptions sdkChannelOptions;

    BootstrapProvider(SdkEventLoopGroup sdkEventLoopGroup, NettyConfiguration nettyConfiguration, SdkChannelOptions sdkChannelOptions) {
        this.sdkEventLoopGroup = sdkEventLoopGroup;
        this.nettyConfiguration = nettyConfiguration;
        this.sdkChannelOptions = sdkChannelOptions;
    }

    public Bootstrap createBootstrap(String host, int port) {
        Bootstrap bootstrap = ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.sdkEventLoopGroup.eventLoopGroup())).channelFactory(this.sdkEventLoopGroup.channelFactory())).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, this.nettyConfiguration.connectTimeoutMillis())).option(ChannelOption.SO_KEEPALIVE, this.nettyConfiguration.tcpKeepAlive())).remoteAddress(InetSocketAddress.createUnresolved(host, port));
        this.sdkChannelOptions.channelOptions().forEach(bootstrap::option);
        return bootstrap;
    }
}

