/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.http.nio.netty.internal.http2;

import codegurushadow.io.netty.buffer.ByteBuf;
import codegurushadow.io.netty.channel.Channel;
import codegurushadow.io.netty.channel.ChannelHandlerContext;
import codegurushadow.io.netty.channel.ChannelOutboundHandlerAdapter;
import codegurushadow.io.netty.channel.ChannelPromise;
import codegurushadow.io.netty.channel.DefaultChannelPromise;
import codegurushadow.io.netty.handler.codec.http.EmptyHttpHeaders;
import codegurushadow.io.netty.handler.codec.http.FullHttpMessage;
import codegurushadow.io.netty.handler.codec.http.HttpContent;
import codegurushadow.io.netty.handler.codec.http.HttpHeaders;
import codegurushadow.io.netty.handler.codec.http.HttpMessage;
import codegurushadow.io.netty.handler.codec.http.LastHttpContent;
import codegurushadow.io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import codegurushadow.io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import codegurushadow.io.netty.handler.codec.http2.EmptyHttp2Headers;
import codegurushadow.io.netty.handler.codec.http2.Http2Headers;
import codegurushadow.io.netty.handler.codec.http2.HttpConversionUtil;
import codegurushadow.io.netty.util.ReferenceCountUtil;
import codegurushadow.io.netty.util.concurrent.EventExecutor;
import codegurushadow.software.amazon.awssdk.annotations.SdkInternalApi;

@SdkInternalApi
public class HttpToHttp2OutboundAdapter
extends ChannelOutboundHandlerAdapter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (!(msg instanceof HttpMessage) && !(msg instanceof HttpContent)) {
            ctx.write(msg, promise);
            return;
        }
        boolean release = true;
        SimpleChannelPromiseAggregator promiseAggregator = new SimpleChannelPromiseAggregator(promise, ctx.channel(), ctx.executor());
        try {
            boolean endStream = false;
            if (msg instanceof HttpMessage) {
                HttpMessage httpMsg = (HttpMessage)msg;
                Http2Headers http2Headers = HttpConversionUtil.toHttp2Headers(httpMsg, false);
                endStream = msg instanceof FullHttpMessage && !((FullHttpMessage)msg).content().isReadable();
                ctx.write(new DefaultHttp2HeadersFrame(http2Headers), promiseAggregator.newPromise());
            }
            if (!endStream && msg instanceof HttpContent) {
                boolean isLastContent = false;
                HttpHeaders trailers = EmptyHttpHeaders.INSTANCE;
                Http2Headers http2Trailers = EmptyHttp2Headers.INSTANCE;
                if (msg instanceof LastHttpContent) {
                    isLastContent = true;
                    LastHttpContent lastContent = (LastHttpContent)msg;
                    trailers = lastContent.trailingHeaders();
                    http2Trailers = HttpConversionUtil.toHttp2Headers(trailers, false);
                }
                ByteBuf content = ((HttpContent)msg).content();
                endStream = isLastContent && trailers.isEmpty();
                release = false;
                ctx.write(new DefaultHttp2DataFrame(content, endStream), promiseAggregator.newPromise());
                if (!trailers.isEmpty()) {
                    ctx.write(new DefaultHttp2HeadersFrame(http2Trailers, true), promiseAggregator.newPromise());
                }
                ctx.flush();
            }
        }
        catch (Throwable t) {
            promiseAggregator.setFailure(t);
        }
        finally {
            if (release) {
                ReferenceCountUtil.release(msg);
            }
            promiseAggregator.doneAllocatingPromises();
        }
    }

    static final class SimpleChannelPromiseAggregator
    extends DefaultChannelPromise {
        private final ChannelPromise promise;
        private int expectedCount;
        private int doneCount;
        private Throwable lastFailure;
        private boolean doneAllocating;

        SimpleChannelPromiseAggregator(ChannelPromise promise, Channel c, EventExecutor e) {
            super(c, e);
            assert (promise != null && !promise.isDone());
            this.promise = promise;
        }

        public ChannelPromise newPromise() {
            assert (!this.doneAllocating) : "Done allocating. No more promises can be allocated.";
            ++this.expectedCount;
            return this;
        }

        public ChannelPromise doneAllocatingPromises() {
            if (!this.doneAllocating) {
                this.doneAllocating = true;
                if (this.doneCount == this.expectedCount || this.expectedCount == 0) {
                    return this.setPromise();
                }
            }
            return this;
        }

        @Override
        public boolean tryFailure(Throwable cause) {
            if (this.allowFailure()) {
                ++this.doneCount;
                this.lastFailure = cause;
                if (this.allPromisesDone()) {
                    return this.tryPromise();
                }
                return true;
            }
            return false;
        }

        @Override
        public ChannelPromise setFailure(Throwable cause) {
            if (this.allowFailure()) {
                ++this.doneCount;
                this.lastFailure = cause;
                if (this.allPromisesDone()) {
                    return this.setPromise();
                }
            }
            return this;
        }

        @Override
        public ChannelPromise setSuccess(Void result) {
            if (this.awaitingPromises()) {
                ++this.doneCount;
                if (this.allPromisesDone()) {
                    this.setPromise();
                }
            }
            return this;
        }

        @Override
        public boolean trySuccess(Void result) {
            if (this.awaitingPromises()) {
                ++this.doneCount;
                if (this.allPromisesDone()) {
                    return this.tryPromise();
                }
                return true;
            }
            return false;
        }

        private boolean allowFailure() {
            return this.awaitingPromises() || this.expectedCount == 0;
        }

        private boolean awaitingPromises() {
            return this.doneCount < this.expectedCount;
        }

        private boolean allPromisesDone() {
            return this.doneCount == this.expectedCount && this.doneAllocating;
        }

        private ChannelPromise setPromise() {
            if (this.lastFailure == null) {
                this.promise.setSuccess();
                return super.setSuccess(null);
            }
            this.promise.setFailure(this.lastFailure);
            return super.setFailure(this.lastFailure);
        }

        private boolean tryPromise() {
            if (this.lastFailure == null) {
                this.promise.trySuccess();
                return super.trySuccess(null);
            }
            this.promise.tryFailure(this.lastFailure);
            return super.tryFailure(this.lastFailure);
        }
    }
}

