/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.software.amazon.awssdk.http.nio.netty.internal.utils;

import codegurushadow.io.netty.channel.Channel;
import codegurushadow.io.netty.channel.ChannelHandler;
import codegurushadow.io.netty.channel.ChannelPipeline;
import codegurushadow.io.netty.util.Attribute;
import codegurushadow.io.netty.util.AttributeKey;
import codegurushadow.software.amazon.awssdk.annotations.SdkInternalApi;
import java.util.NoSuchElementException;
import java.util.Optional;

@SdkInternalApi
public final class ChannelUtils {
    private ChannelUtils() {
    }

    @SafeVarargs
    public static void removeIfExists(ChannelPipeline pipeline, Class<? extends ChannelHandler> ... handlers) {
        for (Class<? extends ChannelHandler> handler : handlers) {
            if (pipeline.get(handler) == null) continue;
            try {
                pipeline.remove(handler);
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
    }

    public static <T> Optional<T> getAttribute(Channel channel, AttributeKey<T> key) {
        return Optional.ofNullable(channel.attr(key)).map(Attribute::get);
    }
}

